/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.reporting.history;

import fitnesse.FitNesseVersion;
import fitnesse.reporting.history.ExecutionReport;
import fitnesse.testsystems.TestSummary;
import fitnesse.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TestExecutionReport
extends ExecutionReport {
    private List<TestResult> results = new ArrayList<TestResult>();

    public TestExecutionReport(FitNesseVersion version, String rootPath) {
        super(version, rootPath);
    }

    public TestExecutionReport(InputStream input) throws IOException, SAXException {
        Document xmlDoc = XmlUtil.newDocument(input);
        this.unpackXml(xmlDoc);
    }

    public TestExecutionReport(File file) throws IOException, SAXException {
        Document xmlDoc = XmlUtil.newDocument(file);
        this.unpackXml(xmlDoc);
    }

    public TestExecutionReport(Document xmlDocument) {
        this.unpackXml(xmlDocument);
    }

    @Override
    protected void unpackResults(Element testResults) {
        NodeList xmlResults = testResults.getElementsByTagName("result");
        for (int resultIndex = 0; resultIndex < xmlResults.getLength(); ++resultIndex) {
            this.unpackResult(xmlResults, resultIndex);
        }
    }

    private void unpackResult(NodeList xmlResults, int resultIndex) {
        Element xmlResult = (Element)xmlResults.item(resultIndex);
        TestResult result = new TestResult();
        result.content = XmlUtil.getTextValue(xmlResult, "content");
        result.right = XmlUtil.getTextValue(xmlResult, "right");
        result.wrong = XmlUtil.getTextValue(xmlResult, "wrong");
        result.ignores = XmlUtil.getTextValue(xmlResult, "ignores");
        result.exceptions = XmlUtil.getTextValue(xmlResult, "exceptions");
        result.relativePageName = XmlUtil.getTextValue(xmlResult, "relativePageName");
        result.tags = XmlUtil.getTextValue(xmlResult, "tags");
        result.dateString = XmlUtil.getTextValue(xmlResult, "date");
        result.runTimeInMillis = XmlUtil.getTextValue(xmlResult, "runTimeInMillis");
        Element xmlInstructions = XmlUtil.getElementByTagName(xmlResult, "instructions");
        if (xmlInstructions != null) {
            this.unpackInstructions(result, xmlInstructions);
        }
        this.addResult(result);
    }

    private void unpackInstructions(TestResult result, Element xmlInstructions) {
        NodeList xmlInstructionResults = xmlInstructions.getElementsByTagName("instructionResult");
        for (int instructionIndex = 0; instructionIndex < xmlInstructionResults.getLength(); ++instructionIndex) {
            Element instructionElement = (Element)xmlInstructionResults.item(instructionIndex);
            String instruction = XmlUtil.getTextValue(instructionElement, "instruction");
            String slimResult = XmlUtil.getTextValue(instructionElement, "slimResult");
            InstructionResult instructionResult = new InstructionResult();
            instructionResult.instruction = instruction;
            instructionResult.slimResult = slimResult;
            result.instructions.add(instructionResult);
            this.unpackExpectations(instructionElement, instructionResult);
        }
    }

    private void unpackExpectations(Element instructionElement, InstructionResult instructionResult) {
        NodeList xmlExpectations = instructionElement.getElementsByTagName("expectation");
        for (int expectationIndex = 0; expectationIndex < xmlExpectations.getLength(); ++expectationIndex) {
            Element expectationElement = (Element)xmlExpectations.item(expectationIndex);
            Expectation expectation = new Expectation();
            instructionResult.addExpectation(expectation);
            expectation.status = XmlUtil.getTextValue(expectationElement, "status");
            expectation.instructionId = XmlUtil.getTextValue(expectationElement, "instructionId");
            expectation.col = XmlUtil.getTextValue(expectationElement, "col");
            expectation.row = XmlUtil.getTextValue(expectationElement, "row");
            expectation.type = XmlUtil.getTextValue(expectationElement, "type");
            expectation.actual = XmlUtil.getTextValue(expectationElement, "actual");
            expectation.expected = XmlUtil.getTextValue(expectationElement, "expected");
            expectation.evaluationMessage = XmlUtil.getTextValue(expectationElement, "evaluationMessage");
        }
    }

    public List<TestResult> getResults() {
        return new ArrayList<TestResult>(this.results);
    }

    public void addResult(TestResult currentResult) {
        this.results.add(currentResult);
    }

    public void toXml(Writer writer, VelocityEngine velocityEngine) {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("response", this);
        Template template = velocityEngine.getTemplate("testResults.vm");
        template.merge(velocityContext, writer);
    }

    public TestSummary getAssertionCounts() {
        TestSummary assertionCounts = new TestSummary();
        for (TestResult result : this.results) {
            assertionCounts.add(result.getTestSummary());
        }
        return assertionCounts;
    }

    public String getContentsOfReport(int reportNumber) {
        return this.results.get(reportNumber).getContent();
    }

    public static class Row
    extends ArrayList<String> {
        private static final long serialVersionUID = 1L;
    }

    public static class Table
    extends ArrayList<Row> {
        private static final long serialVersionUID = 1L;
        private String name;

        public Table(String tableName) {
            this.name = tableName;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Expectation {
        public String instructionId;
        public String col;
        public String row;
        public String type;
        public String actual;
        public String expected;
        public String evaluationMessage;
        public String status;

        public String getInstructionId() {
            return this.instructionId;
        }

        public String getCol() {
            return this.col;
        }

        public String getRow() {
            return this.row;
        }

        public String getType() {
            return this.type;
        }

        public String getActual() {
            return this.actual;
        }

        public String getExpected() {
            return this.expected;
        }

        public String getEvaluationMessage() {
            return this.evaluationMessage;
        }

        public String getStatus() {
            return this.status;
        }
    }

    public static class InstructionResult {
        public String instruction;
        public String slimResult;
        private List<Expectation> expectations = new ArrayList<Expectation>();

        public void addExpectation(Expectation expectation) {
            this.expectations.add(expectation);
        }

        public String getInstruction() {
            return this.instruction;
        }

        public String getSlimResult() {
            return this.slimResult;
        }

        public List<Expectation> getExpectations() {
            return this.expectations;
        }
    }

    public static class TestResult {
        public String right;
        public String wrong;
        public String ignores;
        public String exceptions;
        public String content;
        public String relativePageName;
        public List<InstructionResult> instructions = new ArrayList<InstructionResult>();
        public String tags;
        public String dateString;
        public long startTime;
        public String runTimeInMillis;

        public String getRight() {
            return this.right;
        }

        public String getWrong() {
            return this.wrong;
        }

        public String getIgnores() {
            return this.ignores;
        }

        public String getExceptions() {
            return this.exceptions;
        }

        public String getDateString() {
            return this.dateString;
        }

        public String getRunTimeInMillis() {
            return this.runTimeInMillis;
        }

        public String getContent() {
            return this.content;
        }

        public String getRelativePageName() {
            return this.relativePageName;
        }

        public List<InstructionResult> getInstructions() {
            return this.instructions;
        }

        public String getTags() {
            return this.tags;
        }

        public void setTags(String tags) {
            this.tags = tags;
        }

        public TestSummary getTestSummary() {
            try {
                return new TestSummary(Integer.parseInt(this.right), Integer.parseInt(this.wrong), Integer.parseInt(this.ignores), Integer.parseInt(this.exceptions));
            }
            catch (NumberFormatException e) {
                return new TestSummary();
            }
        }

        public void addInstruction(InstructionResult instructionResult) {
            this.instructions.add(instructionResult);
        }
    }
}

