/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.reporting.history;

import fitnesse.FitNesseContext;
import fitnesse.reporting.BaseFormatter;
import fitnesse.reporting.history.PageHistory;
import fitnesse.reporting.history.SuiteExecutionReport;
import fitnesse.reporting.history.SuiteHistoryFormatter;
import fitnesse.reporting.history.TestExecutionReport;
import fitnesse.reporting.history.TestHistory;
import fitnesse.reporting.history.TestResultRecord;
import fitnesse.wiki.WikiPage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.xml.sax.SAXException;

public class SuiteXmlReformatter
extends BaseFormatter
implements Closeable {
    private static final Logger LOG = Logger.getLogger(SuiteXmlReformatter.class.getName());
    private final FitNesseContext context;
    private final Writer writer;
    private final SuiteHistoryFormatter historyFormatter;
    private boolean includeHtml;
    private boolean includeInstructions;
    private TestHistory testHistory;

    public SuiteXmlReformatter(FitNesseContext context, WikiPage page, Writer writer, SuiteHistoryFormatter historyFormatter) {
        super(page);
        this.context = context;
        this.writer = writer;
        this.historyFormatter = historyFormatter;
    }

    @Override
    public void close() throws IOException {
        this.historyFormatter.close();
        this.testHistory = new TestHistory(this.context.getTestHistoryDirectory());
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("formatter", this);
        velocityContext.put("suiteExecutionReport", this.historyFormatter.getSuiteExecutionReport());
        velocityContext.put("includeHtml", this.includeHtml);
        velocityContext.put("includeInstructions", this.includeInstructions);
        VelocityEngine velocityEngine = this.context.pageFactory.getVelocityEngine();
        Template template = velocityEngine.getTemplate("suiteXML.vm");
        template.merge(velocityContext, this.writer);
        this.writer.close();
    }

    @Override
    public int getErrorCount() {
        return this.historyFormatter.getErrorCount();
    }

    public TestExecutionReport.TestResult getTestResult(SuiteExecutionReport.PageHistoryReference reference) throws IOException, SAXException {
        PageHistory pageHistory = this.testHistory.getPageHistory(reference.getPageName());
        if (pageHistory == null) {
            LOG.log(Level.WARNING, "Unable to get page history");
            return null;
        }
        Date date = new Date(reference.getTime());
        TestResultRecord record = pageHistory.get(date);
        return this.makeTestExecutionReport(record.getFile()).getResults().get(0);
    }

    TestExecutionReport makeTestExecutionReport(File file) throws IOException, SAXException {
        return new TestExecutionReport(file);
    }

    public void includeHtml() {
        this.includeHtml = true;
    }

    public void includeInstructions() {
        this.includeInstructions = true;
    }
}

