/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.HttpException;
import fitnesse.http.UploadedFile;
import fitnesse.util.Base64;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import util.StreamReader;

public class Request {
    private static final Pattern requestLinePattern = Pattern.compile("(\\p{Upper}+?) ([^\\s]+)");
    private static final Pattern requestUriPattern = Pattern.compile("([^?]+)\\??(.*)");
    private static final Pattern queryStringPattern = Pattern.compile("([^=&]*)=?([^&]*)&?");
    private static final Pattern headerPattern = Pattern.compile("([^:]*): (.*)");
    private static final Pattern boundaryPattern = Pattern.compile("boundary=(.*)");
    private static final Pattern multipartHeaderPattern = Pattern.compile("([^ =]+)=\\\"([^\"]*)\\\"");
    private static final Collection<String> allowedMethods = Request.buildAllowedMethodList();
    public static final String NOCHUNK = "nochunk";
    protected StreamReader input;
    private String contextRoot = "/";
    protected String requestURI;
    private String resource;
    protected String queryString;
    protected Map<String, String> inputs = new HashMap<String, String>();
    protected Map<String, String> headers = new HashMap<String, String>();
    protected Map<String, UploadedFile> uploadedFiles = new HashMap<String, UploadedFile>();
    protected String entityBody = "";
    protected String requestLine;
    protected String authorizationUsername;
    protected String authorizationPassword;
    private volatile boolean hasBeenParsed;
    private long bytesParsed = 0L;
    private String peerDn;

    public static Set<String> buildAllowedMethodList() {
        HashSet<String> methods = new HashSet<String>(20);
        methods.add("GET");
        methods.add("POST");
        return methods;
    }

    protected Request() {
    }

    public Request(InputStream input) {
        this.input = new StreamReader(new BufferedInputStream(input));
    }

    public void parse() throws HttpException {
        try {
            this.readAndParseRequestLine();
            this.headers = this.parseHeaders(this.input);
            this.parseEntityBody();
        }
        catch (IOException e) {
            throw new HttpException("Unable to process request: " + e.getMessage());
        }
        this.hasBeenParsed = true;
    }

    private void readAndParseRequestLine() throws IOException, HttpException {
        this.requestLine = this.input.readLine();
        Matcher match = requestLinePattern.matcher(this.requestLine);
        this.checkRequestLine(match);
        this.requestURI = match.group(2);
        this.parseRequestUri(this.requestURI);
    }

    private Map<String, String> parseHeaders(StreamReader reader) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        String line = reader.readLine();
        while (!"".equals(line)) {
            Matcher match = headerPattern.matcher(line);
            if (match.find()) {
                String key = match.group(1);
                String value = match.group(2);
                headers.put(key.toLowerCase(), value);
            }
            line = reader.readLine();
        }
        return headers;
    }

    private void parseEntityBody() throws IOException {
        if (this.hasHeader("Content-Length")) {
            String contentType = this.getHeader("Content-Type");
            if (contentType != null && contentType.startsWith("multipart/form-data")) {
                Matcher match = boundaryPattern.matcher(contentType);
                match.find();
                this.parseMultiPartContent(match.group(1));
            } else {
                this.entityBody = this.input.read(this.getContentLength());
                this.parseQueryString(this.entityBody);
            }
        }
    }

    public int getContentLength() {
        return Integer.parseInt(this.getHeader("Content-Length"));
    }

    private void parseMultiPartContent(String boundary) throws IOException {
        boundary = "--" + boundary;
        int numberOfBytesToRead = this.getContentLength();
        this.accumulateBytesReadAndReset();
        this.input.readUpTo(boundary);
        while ((long)numberOfBytesToRead - this.input.numberOfBytesConsumed() > 10L) {
            this.input.readLine();
            Map<String, String> headers = this.parseHeaders(this.input);
            String contentDisposition = headers.get("content-disposition");
            Matcher matcher = multipartHeaderPattern.matcher(contentDisposition);
            while (matcher.find()) {
                headers.put(matcher.group(1), matcher.group(2));
            }
            String name = headers.get("name");
            if (headers.containsKey("filename")) {
                UploadedFile uploadedFile = this.createUploadedFile(headers, this.input, boundary);
                this.uploadedFiles.put(name, uploadedFile);
                continue;
            }
            String value = this.input.readUpTo("\r\n" + boundary);
            this.inputs.put(name, value);
        }
    }

    private void accumulateBytesReadAndReset() {
        this.bytesParsed += this.input.numberOfBytesConsumed();
        this.input.resetNumberOfBytesConsumed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UploadedFile createUploadedFile(Map<String, String> headers, StreamReader reader, String boundary) throws IOException {
        String filename = headers.get("filename");
        String contentType = headers.get("content-type");
        File tempFile = File.createTempFile("FitNesse", ".uploadedFile");
        OutputStream output = null;
        try {
            output = new BufferedOutputStream(new FileOutputStream(tempFile));
            reader.copyBytesUpTo("\r\n" + boundary, output);
            UploadedFile uploadedFile = new UploadedFile(filename, contentType, tempFile);
            return uploadedFile;
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    private void checkRequestLine(Matcher match) throws HttpException {
        if (!match.find()) {
            throw new HttpException("The request string is malformed and can not be parsed");
        }
        if (!allowedMethods.contains(match.group(1))) {
            throw new HttpException("The " + match.group(1) + " method is not currently supported");
        }
    }

    public void parseRequestUri(String requestUri) {
        Matcher match = requestUriPattern.matcher(requestUri);
        match.find();
        this.resource = this.stripContextRoot(match.group(1));
        this.queryString = match.group(2);
        this.parseQueryString(this.queryString);
    }

    protected void parseQueryString(String queryString) {
        Matcher match = queryStringPattern.matcher(queryString);
        while (match.find()) {
            String key = match.group(1);
            String value = Request.decodeContent(match.group(2));
            this.addUniqueInputString(key, value);
        }
    }

    private void addUniqueInputString(String key, String value) {
        String existingItem = this.inputs.put(key, value);
        if (this.itemExistAndMismatches(existingItem, value)) {
            this.inputs.put(key, this.concatenateItems(existingItem, value));
        }
    }

    private String concatenateItems(String existingItem, String value) {
        return existingItem + ',' + value;
    }

    private boolean itemExistAndMismatches(Object existingItem, String value) {
        return existingItem instanceof String && !value.equals(existingItem);
    }

    public String getRequestLine() {
        return this.requestLine;
    }

    public String getRequestUri() {
        return this.requestURI;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public boolean hasInput(String key) {
        return this.inputs.containsKey(key);
    }

    public String getInput(String key) {
        return this.inputs.get(key);
    }

    public Map<String, String> getMap() {
        return this.inputs;
    }

    public UploadedFile getUploadedFile(String name) {
        return this.uploadedFiles.get(name);
    }

    public boolean hasHeader(String key) {
        return this.headers.containsKey(key.toLowerCase());
    }

    public String getHeader(String key) {
        return this.headers.get(key.toLowerCase());
    }

    public String getBody() {
        return this.entityBody;
    }

    private String stripContextRoot(String url) {
        if (this.contextRoot.equals(url + "/")) {
            return "";
        }
        if (url.startsWith(this.contextRoot)) {
            return url.substring(this.contextRoot.length());
        }
        return url;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("--- Request Start ---\n");
        buffer.append("Request URI:  ").append(this.requestURI).append('\n');
        buffer.append("Resource:     ").append(this.resource).append('\n');
        buffer.append("Query String: ").append(this.queryString).append('\n');
        buffer.append("Hearders: (").append(this.headers.size()).append(")\n");
        this.addMap(this.headers, buffer);
        buffer.append("Form Inputs: (").append(this.inputs.size()).append(")\n");
        this.addMap(this.inputs, buffer);
        buffer.append("Entity Body: \n");
        buffer.append(this.entityBody).append('\n');
        buffer.append("--- End Request ---\n");
        return buffer.toString();
    }

    private void addMap(Map<String, String> map, StringBuilder buffer) {
        if (map.isEmpty()) {
            buffer.append("\tempty");
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String value = entry.getValue() == null ? null : this.escape(entry.getValue());
            buffer.append("\t").append(this.escape(entry.getKey())).append(" \t-->\t ").append(value).append("\n");
        }
    }

    private String escape(String foo) {
        return foo.replaceAll("[\n\r]+", "|");
    }

    public static String decodeContent(String content) {
        try {
            return URLDecoder.decode(content, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "URLDecoder Error";
        }
    }

    public boolean hasBeenParsed() {
        return this.hasBeenParsed;
    }

    public String getUserpass(String headerValue) {
        String encodedUserpass = headerValue.substring(6);
        try {
            return Base64.decode(encodedUserpass);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void getCredentials() {
        String authHeader;
        String userpass;
        String[] values;
        if (this.authorizationUsername != null) {
            return;
        }
        if (this.hasHeader("Authorization") && (values = (userpass = this.getUserpass(authHeader = this.getHeader("Authorization"))).split(":")).length == 2) {
            this.authorizationUsername = values[0];
            this.authorizationPassword = values[1];
        }
    }

    public String getAuthorizationUsername() {
        return this.authorizationUsername;
    }

    public String getAuthorizationPassword() {
        return this.authorizationPassword;
    }

    public String getPeerDn() {
        return this.peerDn;
    }

    public void setPeerDn(String peerDn) {
        this.peerDn = peerDn;
    }

    public long numberOfBytesParsed() {
        return this.bytesParsed + this.input.numberOfBytesConsumed();
    }

    public void setCredentials(String username, String password) {
        this.authorizationUsername = username;
        this.authorizationPassword = password;
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }
}

