/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.html.template;

import fitnesse.FitNesseContext;
import fitnesse.html.template.ClasspathResourceLoader;
import fitnesse.html.template.EscapeDirective;
import fitnesse.html.template.HtmlPage;
import fitnesse.html.template.TraverseDirective;
import fitnesse.html.template.VelocityLogger;
import java.io.StringWriter;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;

public class PageFactory {
    public static final String THEME_PROPERTY = "Theme";
    public static final String DEFAULT_THEME = "bootstrap";
    private final String theme;
    private final String contextRoot;
    private VelocityEngine velocityEngine = null;

    public PageFactory(FitNesseContext context) {
        String theme = context.getProperty(THEME_PROPERTY);
        this.theme = theme != null ? theme : DEFAULT_THEME;
        this.velocityEngine = this.newVelocityEngine(context, this.theme);
        this.contextRoot = context.contextRoot;
    }

    public HtmlPage newPage() {
        return new HtmlPage(this.getVelocityEngine(), "skeleton.vm", this.theme, this.contextRoot);
    }

    public String render(VelocityContext context, String templateName) {
        StringWriter writer = new StringWriter();
        Template template = this.getVelocityEngine().getTemplate(templateName, "UTF-8");
        template.merge(context, writer);
        return ((Object)writer).toString();
    }

    public String getTheme() {
        return this.theme;
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public String toString() {
        return this.getClass().getName();
    }

    private VelocityEngine newVelocityEngine(FitNesseContext context, String theme) {
        Properties properties = new Properties();
        properties.setProperty("input.encoding", "UTF-8");
        properties.setProperty("output.encoding", "UTF-8");
        properties.setProperty("resource.loader", "file,themepath,classpath");
        properties.setProperty("file.resource.loader.path", String.format("%s/files/fitnesse/templates", context.getRootPagePath()));
        properties.setProperty("themepath.resource.loader.class", ClasspathResourceLoader.class.getName());
        properties.setProperty("themepath.resource.loader.base", String.format("/fitnesse/resources/%s/templates", theme));
        properties.setProperty("classpath.resource.loader.class", ClasspathResourceLoader.class.getName());
        properties.setProperty("classpath.resource.loader.base", "/fitnesse/resources/templates");
        properties.setProperty("runtime.log.logsystem.class", VelocityLogger.class.getName());
        VelocityEngine engine = new VelocityEngine();
        engine.init(properties);
        engine.loadDirective(TraverseDirective.class.getName());
        engine.loadDirective(EscapeDirective.class.getName());
        return engine;
    }
}

