/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fitnesse.FitNesseContext;
import fitnesse.FitNesseExpediter;
import fitnesse.FitNesseServer;
import fitnesse.http.MockRequestBuilder;
import fitnesse.http.MockResponseSender;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.socketservice.SocketFactory;
import fitnesse.socketservice.SocketService;
import fitnesse.util.MockSocket;
import fitnesse.util.SerialExecutorService;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FitNesse {
    private static final Logger LOG = Logger.getLogger(FitNesse.class.getName());
    private final FitNesseContext context;
    private boolean makeDirs = true;
    private volatile SocketService theService;
    private ExecutorService executorService;

    public FitNesse(FitNesseContext context) {
        this.context = context;
        RejectedExecutionHandler rejectionHandler = new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                LOG.log(Level.WARNING, "Could not handle request. Thread pool is exhausted.");
            }
        };
        this.executorService = new ThreadPoolExecutor(5, 100, 10L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(2), rejectionHandler);
    }

    public FitNesse dontMakeDirs() {
        this.makeDirs = false;
        return this;
    }

    private void establishRequiredDirectories() {
        FitNesse.establishDirectory(this.context.getRootPagePath());
        FitNesse.establishDirectory(this.context.getRootPagePath() + "/files");
    }

    private static void establishDirectory(String path) {
        File filesDir = new File(path);
        if (!filesDir.exists()) {
            filesDir.mkdir();
        }
    }

    public boolean start() {
        if (this.makeDirs) {
            this.establishRequiredDirectories();
        }
        try {
            if (this.context.port > 0) {
                ServerSocket serverSocket = this.context.useHTTPS ? SocketFactory.createSslServerSocket(this.context.port, this.context.sslClientAuth, this.context.sslParameterClassName) : SocketFactory.createServerSocket(this.context.port);
                this.theService = new SocketService(new FitNesseServer(this.context, this.executorService), false, serverSocket);
            }
            return true;
        }
        catch (BindException e) {
            LOG.severe("FitNesse cannot be started...");
            LOG.severe("Port " + this.context.port + " is already in use.");
            LOG.severe("Use the -p <port#> command line argument to use a different port.");
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error while starting the FitNesse socket service", e);
        }
        return false;
    }

    public void stop() throws IOException {
        if (this.theService != null) {
            this.theService.close();
            this.theService = null;
        }
    }

    public boolean isRunning() {
        return this.theService != null;
    }

    public void executeSingleCommand(String command, OutputStream out) throws Exception {
        FitNesseExpediter expediter = new FitNesseExpediter(new MockSocket(), this.context, new SerialExecutorService());
        Request request = new MockRequestBuilder(command).noChunk().build();
        Response response = expediter.createGoodResponse(request);
        if (response.getStatus() != 200) {
            throw new Exception("error loading page: " + response.getStatus());
        }
        response.withoutHttpHeaders();
        MockResponseSender sender = new MockResponseSender(out);
        sender.doSending(response);
    }
}

