/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.io;

import com.google.common.collect.Sets;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryFiles {
    private static final ThreadLocal<Set<TemporaryFile>> tempFiles = new ThreadLocal<Set<TemporaryFile>>(){

        @Override
        protected Set<TemporaryFile> initialValue() {
            return Sets.newHashSet();
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(TemporaryFiles.class);

    public static void register(TemporaryFile temporaryFile) {
        tempFiles.get().add(temporaryFile);
    }

    public static void clear() {
        for (TemporaryFile tempFile : Sets.newHashSet((Iterable)tempFiles.get())) {
            logger.debug("Trying to delete {}", (Object)tempFile);
            if (tempFile.deleteExplicitly()) {
                tempFiles.get().remove(tempFile);
                continue;
            }
            logger.warn("Couldn't delete {}", (Object)tempFile);
        }
    }

    public static interface TemporaryFile {
        public void delete();

        public boolean deleteExplicitly();
    }
}

