/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks.containers;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.util.concurrent.locks.VisibleOwnerReentrantLock;
import org.infinispan.util.concurrent.locks.containers.AbstractStripedLockContainer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class ReentrantStripedLockContainer
extends AbstractStripedLockContainer<VisibleOwnerReentrantLock> {
    private final VisibleOwnerReentrantLock[] sharedLocks;
    private static final Log log = LogFactory.getLog(ReentrantStripedLockContainer.class);

    @Override
    protected Log getLog() {
        return log;
    }

    public ReentrantStripedLockContainer(int concurrencyLevel, Equivalence<Object> keyEquivalence) {
        super(keyEquivalence);
        int numLocks = this.calculateNumberOfSegments(concurrencyLevel);
        this.sharedLocks = new VisibleOwnerReentrantLock[numLocks];
        for (int i = 0; i < numLocks; ++i) {
            this.sharedLocks[i] = new VisibleOwnerReentrantLock();
        }
    }

    @Override
    public final VisibleOwnerReentrantLock getLock(Object object) {
        return this.sharedLocks[this.hashToIndex(object)];
    }

    @Override
    public final int getNumLocksHeld() {
        int i = 0;
        for (VisibleOwnerReentrantLock l : this.sharedLocks) {
            if (!l.isLocked()) continue;
            ++i;
        }
        return i;
    }

    @Override
    public int size() {
        return this.sharedLocks.length;
    }

    @Override
    public final boolean ownsLock(Object object, Object ignored) {
        VisibleOwnerReentrantLock lock = this.getLock(object);
        return lock.isHeldByCurrentThread();
    }

    @Override
    public final boolean isLocked(Object object) {
        VisibleOwnerReentrantLock lock = this.getLock(object);
        return lock.isLocked();
    }

    public String toString() {
        return "ReentrantStripedLockContainer{sharedLocks=" + Arrays.toString(this.sharedLocks) + '}';
    }

    @Override
    protected void unlock(VisibleOwnerReentrantLock l, Object unused) {
        l.unlock();
    }

    @Override
    protected boolean tryLock(VisibleOwnerReentrantLock lock, long timeout, TimeUnit unit, Object unused) throws InterruptedException {
        return lock.tryLock(timeout, unit);
    }

    @Override
    protected void lock(VisibleOwnerReentrantLock lock, Object lockOwner) {
        lock.lock();
    }
}

