/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.executors;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class ExecutorAllCompletionService
implements CompletionService<Void> {
    private ExecutorCompletionService executorService;
    private AtomicReference<ExecutionException> firstException = new AtomicReference();
    private AtomicLong scheduled = new AtomicLong();
    private AtomicLong completed = new AtomicLong();

    public ExecutorAllCompletionService(Executor executor) {
        this.executorService = new ExecutorCompletionService(executor);
    }

    @Override
    public Future<Void> submit(Callable<Void> task) {
        this.scheduled.incrementAndGet();
        Future<Void> future = this.executorService.submit(task);
        this.pollUntilEmpty();
        return future;
    }

    @Override
    public Future<Void> submit(Runnable task, Void result) {
        this.scheduled.incrementAndGet();
        Future<Void> future = this.executorService.submit(task, result);
        this.pollUntilEmpty();
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollUntilEmpty() {
        Future completedFuture;
        while ((completedFuture = this.executorService.poll()) != null) {
            try {
                completedFuture.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                if (this.firstException.get() != null) continue;
                this.firstException.compareAndSet(null, e);
            }
            finally {
                this.completed.incrementAndGet();
            }
        }
    }

    public boolean isAllCompleted() {
        this.pollUntilEmpty();
        return this.completed.get() >= this.scheduled.get();
    }

    public long getScheduledTasks() {
        return this.scheduled.get();
    }

    public long getCompletedTasks() {
        return this.completed.get();
    }

    public void waitUntilAllCompleted() {
        while (this.completed.get() < this.scheduled.get()) {
            try {
                Future<Void> future = this.poll(100L, TimeUnit.MILLISECONDS);
                if (future == null) continue;
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (ExecutionException e) {
                if (this.firstException.get() != null) continue;
                this.firstException.compareAndSet(null, e);
            }
        }
    }

    public boolean isExceptionThrown() {
        return this.firstException.get() != null;
    }

    public ExecutionException getFirstException() {
        return this.firstException.get();
    }

    @Override
    public Future<Void> take() throws InterruptedException {
        Future<Void> future = this.executorService.take();
        this.completed.incrementAndGet();
        return future;
    }

    @Override
    public Future<Void> poll() {
        Future<Void> future = this.executorService.poll();
        if (future != null) {
            this.completed.incrementAndGet();
        }
        return future;
    }

    @Override
    public Future<Void> poll(long timeout, TimeUnit unit) throws InterruptedException {
        Future<Void> future = this.executorService.poll(timeout, unit);
        if (future != null) {
            this.completed.incrementAndGet();
        }
        return future;
    }
}

