/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container;

import org.infinispan.container.EntryFactoryImpl;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ClusteredRepeatableReadEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.Metadatas;
import org.infinispan.transaction.impl.AbstractCacheTransaction;

public class IncrementalVersionableEntryFactoryImpl
extends EntryFactoryImpl {
    private VersionGenerator versionGenerator;

    @Start(priority=9)
    public void setWriteSkewCheckFlag() {
        this.useRepeatableRead = true;
    }

    @Inject
    public void injectVersionGenerator(VersionGenerator versionGenerator) {
        this.versionGenerator = versionGenerator;
    }

    @Override
    protected MVCCEntry createWrappedEntry(Object key, CacheEntry cacheEntry, InvocationContext context, Metadata providedMetadata, boolean isForInsert, boolean forRemoval, boolean skipRead) {
        Metadata metadata;
        Object value;
        if (cacheEntry != null) {
            value = cacheEntry.getValue();
            Metadata entryMetadata = cacheEntry.getMetadata();
            metadata = providedMetadata != null && entryMetadata != null ? Metadatas.applyVersion(entryMetadata, providedMetadata) : (providedMetadata == null ? entryMetadata : providedMetadata);
            if (context.isOriginLocal() && context.isInTxScope()) {
                ((AbstractCacheTransaction)((TxInvocationContext)context).getCacheTransaction()).addVersionRead(key, skipRead ? null : metadata.version());
            }
        } else {
            value = null;
            Metadata metadata2 = metadata = providedMetadata == null ? new EmbeddedMetadata.Builder().version(this.versionGenerator.nonExistingVersion()).build() : providedMetadata;
            if (context.isOriginLocal() && context.isInTxScope()) {
                ((AbstractCacheTransaction)((TxInvocationContext)context).getCacheTransaction()).addVersionRead(key, skipRead ? null : this.versionGenerator.nonExistingVersion());
            }
        }
        return new ClusteredRepeatableReadEntry(key, value, metadata);
    }
}

