/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.affinity.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.affinity.ListenerRegistration;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.ConcurrentHashSet;
import org.infinispan.util.concurrent.ReclosableLatch;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class KeyAffinityServiceImpl<K>
implements KeyAffinityService<K> {
    public static final float THRESHOLD = 0.5f;
    private static final int POLL_INTERVAL_MILLIS = 50;
    private static final Log log = LogFactory.getLog(KeyAffinityServiceImpl.class);
    private final Set<Address> filter;
    @GuardedBy(value="maxNumberInvariant")
    private final Map<Address, BlockingQueue<K>> address2key = CollectionFactory.makeConcurrentMap();
    private final Executor executor;
    private final Cache<? extends K, ?> cache;
    private final KeyGenerator<? extends K> keyGenerator;
    private final int bufferSize;
    private final AtomicInteger maxNumberOfKeys = new AtomicInteger();
    final AtomicInteger existingKeyCount = new AtomicInteger();
    private volatile boolean started;
    private final ReadWriteLock maxNumberInvariant = new ReentrantReadWriteLock();
    private final ReclosableLatch keyProducerStartLatch = new ReclosableLatch();
    private volatile KeyGeneratorWorker keyGenWorker;
    private volatile ListenerRegistration listenerRegistration;

    public KeyAffinityServiceImpl(Executor executor, Cache<? extends K, ?> cache, KeyGenerator<? extends K> keyGenerator, int bufferSize, Collection<Address> filter, boolean start) {
        this.executor = executor;
        this.cache = cache;
        this.keyGenerator = keyGenerator;
        this.bufferSize = bufferSize;
        if (filter != null) {
            this.filter = new ConcurrentHashSet<Address>();
            for (Address address : filter) {
                this.filter.add(address);
            }
        } else {
            this.filter = null;
        }
        if (start) {
            this.start();
        }
    }

    @Override
    public K getCollocatedKey(K otherKey) {
        Address address = this.getAddressForKey(otherKey);
        return this.getKeyForAddress(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public K getKeyForAddress(Address address) {
        if (!this.started) {
            throw new IllegalStateException("You have to start the service first!");
        }
        if (address == null) {
            throw new NullPointerException("Null address not supported!");
        }
        BlockingQueue<K> queue = null;
        try {
            K result = null;
            while (result == null && !this.keyGenWorker.isStopped()) {
                this.maxNumberInvariant.readLock().lock();
                try {
                    queue = this.address2key.get(address);
                    if (queue == null) {
                        throw new IllegalStateException("Address " + address + " is no longer in the cluster");
                    }
                    result = (K)queue.poll();
                    if (result == null) {
                        this.keyProducerStartLatch.open();
                        if (!this.isNodeInConsistentHash(address)) {
                            throw new IllegalStateException("Address " + address + " is no longer in the cluster");
                        }
                    }
                }
                finally {
                    this.maxNumberInvariant.readLock().unlock();
                }
                if (result != null) continue;
                try {
                    result = queue.poll(50L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.existingKeyCount.decrementAndGet();
            log.tracef("Returning key %s for address %s", result, address);
            K k = result;
            return k;
        }
        finally {
            if (queue != null && (float)queue.size() < (float)this.bufferSize * 0.5f + 1.0f) {
                this.keyProducerStartLatch.open();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.started) {
            log.debug("Service already started, ignoring call to start!");
            return;
        }
        List<Address> existingNodes = this.getExistingNodes();
        this.maxNumberInvariant.writeLock().lock();
        try {
            this.addQueuesForAddresses(existingNodes);
            this.resetNumberOfKeys();
        }
        finally {
            this.maxNumberInvariant.writeLock().unlock();
        }
        this.keyGenWorker = new KeyGeneratorWorker();
        this.executor.execute(this.keyGenWorker);
        this.listenerRegistration = new ListenerRegistration(this);
        this.cache.getCacheManager().addListener(this.listenerRegistration);
        this.cache.addListener(this.listenerRegistration);
        this.keyProducerStartLatch.open();
        this.started = true;
    }

    public void stop() {
        if (!this.started) {
            log.debug("Ignoring call to stop as service is not started.");
            return;
        }
        this.started = false;
        EmbeddedCacheManager cacheManager = this.cache.getCacheManager();
        if (!cacheManager.getListeners().contains(this.listenerRegistration)) {
            throw new IllegalStateException("Listener must have been registered!");
        }
        cacheManager.removeListener(this.listenerRegistration);
        if (this.cache.getListeners().contains(this.listenerRegistration)) {
            this.cache.removeListener(this.listenerRegistration);
        }
        this.keyGenWorker.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleViewChange(TopologyChangedEvent<?, ?> vce) {
        log.tracef("TopologyChangedEvent received: %s", vce);
        this.maxNumberInvariant.writeLock().lock();
        try {
            this.address2key.clear();
            this.addQueuesForAddresses(vce.getConsistentHashAtEnd().getMembers());
            this.resetNumberOfKeys();
            this.keyProducerStartLatch.open();
        }
        finally {
            this.maxNumberInvariant.writeLock().unlock();
        }
    }

    public boolean isKeyGeneratorThreadAlive() {
        return !this.keyGenWorker.isStopped();
    }

    public void handleCacheStopped(CacheStoppedEvent cse) {
        if (this.cache.getName().equals(cse.getCacheName())) {
            log.tracef("Cache stopped, stopping the service: %s", cse);
            this.stop();
        }
    }

    private void resetNumberOfKeys() {
        this.maxNumberOfKeys.set(this.address2key.keySet().size() * this.bufferSize);
        this.existingKeyCount.set(0);
        if (log.isTraceEnabled()) {
            log.tracef("resetNumberOfKeys ends with: maxNumberOfKeys=%s, existingKeyCount=%s", this.maxNumberOfKeys.get(), this.existingKeyCount.get());
        }
    }

    private void addQueuesForAddresses(Collection<Address> addresses) {
        for (Address address : addresses) {
            if (this.interestedInAddress(address)) {
                this.address2key.put(address, new ArrayBlockingQueue(this.bufferSize));
                continue;
            }
            log.tracef("Skipping address: %s", address);
        }
    }

    private boolean interestedInAddress(Address address) {
        return this.filter == null || this.filter.contains(address);
    }

    private List<Address> getExistingNodes() {
        return this.cache.getAdvancedCache().getRpcManager().getTransport().getMembers();
    }

    private Address getAddressForKey(Object key) {
        DistributionManager distributionManager = this.getDistributionManager();
        ConsistentHash hash = distributionManager.getConsistentHash();
        return hash.locatePrimaryOwner(key);
    }

    private boolean isNodeInConsistentHash(Address address) {
        DistributionManager distributionManager = this.getDistributionManager();
        ConsistentHash hash = distributionManager.getConsistentHash();
        return hash.getMembers().contains(address);
    }

    private DistributionManager getDistributionManager() {
        DistributionManager distributionManager = this.cache.getAdvancedCache().getDistributionManager();
        if (distributionManager == null) {
            throw new IllegalStateException("Null distribution manager. Is this an distributed(v.s. replicated) cache?");
        }
        return distributionManager;
    }

    public Map<Address, BlockingQueue<K>> getAddress2KeysMapping() {
        return Collections.unmodifiableMap(this.address2key);
    }

    public int getMaxNumberOfKeys() {
        return this.maxNumberOfKeys.intValue();
    }

    public boolean isKeyGeneratorThreadActive() {
        return this.keyGenWorker.isActive();
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    private class KeyGeneratorWorker
    implements Runnable {
        private volatile boolean isActive;
        private volatile boolean isStopped = false;

        private KeyGeneratorWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.isStopped) {
                    KeyAffinityServiceImpl.this.keyProducerStartLatch.await();
                    if (this.isStopped) continue;
                    this.isActive = true;
                    log.trace("KeyGeneratorWorker marked as ACTIVE");
                    this.generateKeys();
                    this.isActive = false;
                    log.trace("KeyGeneratorWorker marked as INACTIVE");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                log.debugf("Shutting down KeyAffinity service for key set: %s", KeyAffinityServiceImpl.this.filter);
            }
        }

        public boolean isStopped() {
            return this.isStopped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void generateKeys() {
            KeyAffinityServiceImpl.this.maxNumberInvariant.readLock().lock();
            try {
                int maxMisses = KeyAffinityServiceImpl.this.maxNumberOfKeys.get();
                int missCount = 0;
                while (KeyAffinityServiceImpl.this.existingKeyCount.get() < KeyAffinityServiceImpl.this.maxNumberOfKeys.get() && missCount < maxMisses) {
                    Object key = KeyAffinityServiceImpl.this.keyGenerator.getKey();
                    Address addressForKey = KeyAffinityServiceImpl.this.getAddressForKey(key);
                    boolean added = false;
                    if (KeyAffinityServiceImpl.this.interestedInAddress(addressForKey)) {
                        added = this.tryAddKey(addressForKey, key);
                    }
                    if (added) continue;
                    ++missCount;
                }
                if (missCount < maxMisses) {
                    KeyAffinityServiceImpl.this.keyProducerStartLatch.close();
                }
            }
            finally {
                KeyAffinityServiceImpl.this.maxNumberInvariant.readLock().unlock();
            }
        }

        private boolean tryAddKey(Address address, K key) {
            BlockingQueue queue = (BlockingQueue)KeyAffinityServiceImpl.this.address2key.get(address);
            if (queue == null) {
                return false;
            }
            boolean added = queue.offer(key);
            if (added) {
                KeyAffinityServiceImpl.this.existingKeyCount.incrementAndGet();
                log.tracef("Added key %s for address %s", key, address);
            }
            return added;
        }

        public boolean isActive() {
            return this.isActive;
        }

        public void stop() {
            this.isStopped = true;
            KeyAffinityServiceImpl.this.keyProducerStartLatch.open();
        }
    }
}

