/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.util;

import java.util.List;
import java.util.ListIterator;
import org.apache.commons.cli2.validation.FileValidator;
import org.apache.commons.cli2.validation.InvalidArgumentException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.rzo.yajsw.util.VFSUtils;

public class VFSFileValidator
extends FileValidator {
    String _base = null;

    public VFSFileValidator setBase(String base) {
        this._base = base;
        return this;
    }

    public static VFSFileValidator getExistingInstance() {
        VFSFileValidator validator = null;
        try {
            validator = new VFSFileValidator();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        validator.setExisting(true);
        return validator;
    }

    public static VFSFileValidator getExistingFileInstance() {
        VFSFileValidator validator = null;
        try {
            validator = new VFSFileValidator();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        validator.setExisting(true);
        validator.setFile(true);
        return validator;
    }

    public static VFSFileValidator getExistingDirectoryInstance() {
        VFSFileValidator validator = null;
        try {
            validator = new VFSFileValidator();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        validator.setExisting(true);
        validator.setDirectory(true);
        return validator;
    }

    public void validate(List values) throws InvalidArgumentException {
        ListIterator<String> i = values.listIterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            try {
                FileObject f = VFSUtils.resolveFile(this._base, name);
                if (this.isExisting() && !f.exists() || this.isFile() && !f.getType().equals((Object)FileType.FILE) || this.isDirectory() && !f.getType().equals((Object)FileType.FILE) || this.isHidden() && !f.isHidden() || this.isReadable() && !f.isReadable() || this.isWritable() && !f.isWriteable()) {
                    throw new InvalidArgumentException(name);
                }
                i.set(name);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new InvalidArgumentException(name);
            }
        }
    }
}

