/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.local;

import java.util.Map;
import javax.jcr.query.qom.BindVariableValue;
import javax.jcr.query.qom.StaticOperand;
import org.modeshape.jcr.index.local.LocalIndexException;
import org.modeshape.jcr.index.local.MapDB;
import org.modeshape.jcr.query.model.Literal;
import org.modeshape.jcr.value.ValueFactory;

public class IndexValues {
    public static <T> Converter<MapDB.UniqueKey<T>> uniqueKeyConverter(Converter<T> converter) {
        return new UniqueKeyConverter<T>(converter);
    }

    public static <T> Converter<T> converter(ValueFactory<T> factory) {
        return new StandardConverter<T>(factory);
    }

    private IndexValues() {
    }

    protected static class StandardConverter<T>
    implements Converter<T> {
        private final ValueFactory<T> factory;

        protected StandardConverter(ValueFactory<T> factory) {
            this.factory = factory;
        }

        @Override
        public T toLowerValue(StaticOperand operand, Map<String, Object> variables) {
            if (operand instanceof Literal) {
                Literal literal = (Literal)operand;
                return this.factory.create(literal.value());
            }
            if (operand instanceof BindVariableValue) {
                BindVariableValue bind = (BindVariableValue)operand;
                return this.factory.create(variables.get(bind.getBindVariableName()));
            }
            throw new LocalIndexException("Unexpected static operand: " + operand);
        }

        @Override
        public T toUpperValue(StaticOperand operand, Map<String, Object> variables) {
            if (operand instanceof Literal) {
                Literal literal = (Literal)operand;
                return this.factory.create(literal.value());
            }
            if (operand instanceof BindVariableValue) {
                BindVariableValue bind = (BindVariableValue)operand;
                return this.factory.create(variables.get(bind.getBindVariableName()));
            }
            throw new LocalIndexException("Unexpected static operand: " + operand);
        }
    }

    static final class UniqueKeyConverter<T>
    implements Converter<MapDB.UniqueKey<T>> {
        private final Converter<T> valueConverter;

        protected UniqueKeyConverter(Converter<T> valueConverter) {
            this.valueConverter = valueConverter;
        }

        @Override
        public MapDB.UniqueKey<T> toLowerValue(StaticOperand operand, Map<String, Object> variables) {
            T value = this.valueConverter.toLowerValue(operand, variables);
            return value != null ? new MapDB.UniqueKey<T>(value, 0L) : null;
        }

        @Override
        public MapDB.UniqueKey<T> toUpperValue(StaticOperand operand, Map<String, Object> variables) {
            T value = this.valueConverter.toLowerValue(operand, variables);
            return value != null ? new MapDB.UniqueKey<T>(value, Long.MAX_VALUE) : null;
        }
    }

    public static interface Converter<T> {
        public T toLowerValue(StaticOperand var1, Map<String, Object> var2);

        public T toUpperValue(StaticOperand var1, Map<String, Object> var2);
    }
}

