# NOTE: Please do not edit this file directly
# Create your custom reports in the 'ext' folder

import re

def prefix_within_hierarchy(event, prefix_array):
    hierarchy = get_hierarchy(event)
    result = False
    if hierarchy:
        result = hierarchy[:len(prefix_array)] == prefix_array

    return result

def next_node_in_hierarchy(event, prefix_array):
    hierarchy = get_hierarchy(event)
    return hierarchy[len(prefix_array)]

def get_prefix_param(query_parameters):
    return query_parameters.get('prefix') or ''

def get_hierarchy_from_param(param):
    return re.split(';', param) if param else []

def get_prefix_array(query_parameters):
    prefix_param = get_prefix_param(query_parameters)
    return get_hierarchy_from_param(prefix_param)

def get_suite_name(hierarchy):
    if len(hierarchy) > 1:
        return hierarchy[-1] # the last part is always suite name (child)
    elif len(hierarchy) == 1:
        return hierarchy[0] # the only child
    else:
        return ''

def get_parent_suite(hierarchy):
    if len(hierarchy) > 1:
        return hierarchy[-2] # the part before the last part is always parent
    else:
        return '' # when only 1 (or less) element, the parent is no more (root level)

def get_hierarchy(event):
    if event:
        return event.get('@hierarchy')
    else:
        return [] # keep our reports lenient by not crashing but return an empty result

def get_prefix_from_hierarchy(event, level):
    hierarchy = get_hierarchy(event)
    if level >= hierarchy:
        return ";".join(hierarchy)
    else:
        return ';'.join(hierarchy[:level])

def is_functional_result(event):
    if event:
        return event.type == 'functionalResult'
    else:
        return False  # keep our reports lenient by not crashing but return False

def is_performance_result(event):
    if event:
        return event.type == 'performanceResult'
    else:
        return False # keep our reports lenient by not crashing but return False
