/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.Maybe;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.ScanString;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;

public class LineRule
implements Rule {
    public static final String Level = "level";

    @Override
    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        Symbol next = parser.moveNext(1);
        if (!next.isType(SymbolType.Whitespace)) {
            return Symbol.nothing;
        }
        String level = current.getContent().substring(1, 2);
        if (ScanString.isDigits(level)) {
            current.putProperty(Level, level);
        }
        current.add(parser.parseToEnd(SymbolType.Newline));
        if (parser.peek().isType(SymbolType.Newline) && !parser.endsOn(SymbolType.Newline)) {
            parser.moveNext(1);
        }
        return new Maybe<Symbol>(current);
    }
}

