/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.tables.SyntaxError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DecisionTableCaller {
    protected ColumnHeaderStore constructorParameterStore = new ColumnHeaderStore();
    protected ColumnHeaderStore varStore = new ColumnHeaderStore();
    protected ColumnHeaderStore funcStore = new ColumnHeaderStore();
    protected int columnHeaders;
    private final Table table;

    public DecisionTableCaller(Table table) {
        this.table = table;
    }

    protected void gatherConstructorParameters() {
        this.columnHeaders = this.table.getColumnCountInRow(0);
        for (int col = 3; col < this.columnHeaders; col += 2) {
            String cell = this.table.getCellContents(col - 1, 0);
            this.constructorParameterStore.add(cell, col);
        }
    }

    protected void gatherFunctionsAndVariablesFromColumnHeader() {
        this.columnHeaders = this.table.getColumnCountInRow(1);
        for (int col = 0; col < this.columnHeaders; ++col) {
            this.putColumnHeaderInFunctionOrVariableList(col);
        }
    }

    private void putColumnHeaderInFunctionOrVariableList(int col) {
        String cell = this.table.getCellContents(col, 1);
        if (!cell.startsWith("#")) {
            if (cell.endsWith("?") || cell.endsWith("!")) {
                String funcName = cell.substring(0, cell.length() - 1);
                this.funcStore.add(funcName, col);
            } else {
                this.varStore.add(cell, col);
            }
        }
    }

    protected void checkRow(int row) throws SyntaxError {
        int columns = this.table.getColumnCountInRow(row);
        if (columns < this.columnHeaders) {
            throw new SyntaxError(String.format("Table has %d header column%s, but row %d only has %d column%s.", this.columnHeaders, this.plural(this.columnHeaders), row, columns, this.plural(columns)));
        }
    }

    private String plural(int n) {
        return n == 1 ? "" : "s";
    }

    protected class ColumnHeaderStore {
        private Map<String, List<Integer>> columnNumbers = new HashMap<String, List<Integer>>();
        private Map<String, Iterator<Integer>> columnNumberIterator;
        private List<String> leftToRight = new ArrayList<String>();

        protected ColumnHeaderStore() {
        }

        public void add(String header, int columnNumber) {
            this.leftToRight.add(header);
            this.getColumnNumbers(header).add(columnNumber);
        }

        private List<Integer> getColumnNumbers(String header) {
            if (!this.columnNumbers.containsKey(header)) {
                this.columnNumbers.put(header, new ArrayList());
            }
            return this.columnNumbers.get(header);
        }

        public int getColumnNumber(String functionName) {
            return this.columnNumberIterator.get(functionName).next();
        }

        public List<String> getLeftToRightAndResetColumnNumberIterator() {
            this.resetColumnNumberIterator();
            return this.leftToRight;
        }

        private void resetColumnNumberIterator() {
            this.columnNumberIterator = new HashMap<String, Iterator<Integer>>();
            for (String header : this.columnNumbers.keySet()) {
                this.columnNumberIterator.put(header, this.columnNumbers.get(header).iterator());
            }
        }
    }
}

