/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.fielddata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.fielddata.FieldDataFieldsContext;
import org.elasticsearch.search.fetch.fielddata.FieldDataFieldsParseElement;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.InternalSearchHitField;
import org.elasticsearch.search.internal.SearchContext;

public class FieldDataFieldsFetchSubPhase
implements FetchSubPhase {
    @Inject
    public FieldDataFieldsFetchSubPhase() {
    }

    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        ImmutableMap.Builder<String, FieldDataFieldsParseElement> parseElements = ImmutableMap.builder();
        parseElements.put("fielddata_fields", new FieldDataFieldsParseElement()).put("fielddataFields", new FieldDataFieldsParseElement());
        return parseElements.build();
    }

    @Override
    public boolean hitsExecutionNeeded(SearchContext context) {
        return false;
    }

    @Override
    public void hitsExecute(SearchContext context, InternalSearchHit[] hits) throws ElasticsearchException {
    }

    @Override
    public boolean hitExecutionNeeded(SearchContext context) {
        return context.hasFieldDataFields();
    }

    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) throws ElasticsearchException {
        for (FieldDataFieldsContext.FieldDataField field : context.fieldDataFields().fields()) {
            FieldMapper mapper;
            SearchHitField hitField;
            if (hitContext.hit().fieldsOrNull() == null) {
                hitContext.hit().fields(new HashMap<String, SearchHitField>(2));
            }
            if ((hitField = hitContext.hit().fields().get(field.name())) == null) {
                hitField = new InternalSearchHitField(field.name(), new ArrayList<Object>(2));
                hitContext.hit().fields().put(field.name(), hitField);
            }
            if ((mapper = context.mapperService().smartNameFieldMapper(field.name())) == null) continue;
            Object data = context.fieldData().getForField(mapper).load(hitContext.readerContext());
            ScriptDocValues values = data.getScriptValues();
            values.setNextDocId(hitContext.docId());
            hitField.values().addAll(values.getValues());
        }
    }
}

