/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.util.Callback;

public abstract class Streams {
    public static final int BUFFER_SIZE = 8192;

    public static long copy(File in, File out) throws IOException {
        Preconditions.checkNotNull(in, "No input File specified");
        Preconditions.checkNotNull(out, "No output File specified");
        return Streams.copy(new BufferedInputStream(new FileInputStream(in)), (OutputStream)new BufferedOutputStream(new FileOutputStream(out)));
    }

    public static void copy(byte[] in, File out) throws IOException {
        Preconditions.checkNotNull(in, "No input byte array specified");
        Preconditions.checkNotNull(out, "No output File specified");
        ByteArrayInputStream inStream = new ByteArrayInputStream(in);
        BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(out));
        Streams.copy(inStream, (OutputStream)outStream);
    }

    public static byte[] copyToByteArray(File in) throws IOException {
        Preconditions.checkNotNull(in, "No input File specified");
        return Streams.copyToByteArray(new BufferedInputStream(new FileInputStream(in)));
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        return Streams.copy(in, out, new byte[8192]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        Preconditions.checkNotNull(in, "No InputStream specified");
        Preconditions.checkNotNull(out, "No OutputStream specified");
        try {
            int bytesRead;
            long byteCount = 0L;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += (long)bytesRead;
            }
            out.flush();
            long l = byteCount;
            return l;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {}
            try {
                out.close();
            }
            catch (IOException ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(byte[] in, OutputStream out) throws IOException {
        Preconditions.checkNotNull(in, "No input byte array specified");
        Preconditions.checkNotNull(out, "No OutputStream specified");
        try {
            out.write(in);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] copyToByteArray(InputStream in) throws IOException {
        BytesStreamOutput out = new BytesStreamOutput();
        Streams.copy(in, (OutputStream)out);
        return out.bytes().toBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(Reader in, Writer out) throws IOException {
        Preconditions.checkNotNull(in, "No Reader specified");
        Preconditions.checkNotNull(out, "No Writer specified");
        try {
            int bytesRead;
            int byteCount = 0;
            char[] buffer = new char[8192];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            int n = byteCount;
            return n;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {}
            try {
                out.close();
            }
            catch (IOException ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String in, Writer out) throws IOException {
        Preconditions.checkNotNull(in, "No input String specified");
        Preconditions.checkNotNull(out, "No Writer specified");
        try {
            out.write(in);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String copyToString(Reader in) throws IOException {
        StringWriter out = new StringWriter();
        Streams.copy(in, (Writer)out);
        return out.toString();
    }

    public static String copyToStringFromClasspath(ClassLoader classLoader, String path) throws IOException {
        InputStream is = classLoader.getResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException("Resource [" + path + "] not found in classpath with class loader [" + classLoader + "]");
        }
        return Streams.copyToString(new InputStreamReader(is, Charsets.UTF_8));
    }

    public static String copyToStringFromClasspath(String path) throws IOException {
        InputStream is = Streams.class.getResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException("Resource [" + path + "] not found in classpath");
        }
        return Streams.copyToString(new InputStreamReader(is, Charsets.UTF_8));
    }

    public static byte[] copyToBytesFromClasspath(String path) throws IOException {
        InputStream is = Streams.class.getResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException("Resource [" + path + "] not found in classpath");
        }
        return Streams.copyToByteArray(is);
    }

    public static int readFully(Reader reader, char[] dest) throws IOException {
        return Streams.readFully(reader, dest, 0, dest.length);
    }

    public static int readFully(Reader reader, char[] dest, int offset, int len) throws IOException {
        int read;
        int r;
        for (read = 0; read < len && (r = reader.read(dest, offset + read, len - read)) != -1; read += r) {
        }
        return read;
    }

    public static int readFully(InputStream reader, byte[] dest) throws IOException {
        return Streams.readFully(reader, dest, 0, dest.length);
    }

    public static int readFully(InputStream reader, byte[] dest, int offset, int len) throws IOException {
        int read;
        int r;
        for (read = 0; read < len && (r = reader.read(dest, offset + read, len - read)) != -1; read += r) {
        }
        return read;
    }

    public static List<String> readAllLines(InputStream input) throws IOException {
        final ArrayList<String> lines = Lists.newArrayList();
        Streams.readAllLines(input, new Callback<String>(){

            @Override
            public void handle(String line) {
                lines.add(line);
            }
        });
        return lines;
    }

    public static void readAllLines(InputStream input, Callback<String> callback) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, Charsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                callback.handle(line);
            }
        }
    }
}

