/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.AbstractBinaryStore;
import org.modeshape.jcr.value.binary.FileLocks;
import org.modeshape.jcr.value.binary.NamedLocks;

public final class SharedLockingInputStream
extends InputStream {
    protected final BinaryKey key;
    protected final File file;
    protected final NamedLocks lockManager;
    protected InputStream stream;
    protected Lock processLock;
    protected FileLocks.WrappedLock fileLock;
    protected boolean eofReached;

    public SharedLockingInputStream(BinaryKey key, File file, NamedLocks lockManager) {
        assert (key != null);
        assert (file != null);
        this.key = key;
        this.file = file;
        this.lockManager = lockManager;
    }

    protected void open() throws IOException {
        this.doOperation(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (SharedLockingInputStream.this.stream == null) {
                    if (SharedLockingInputStream.this.lockManager != null) {
                        SharedLockingInputStream.this.processLock = SharedLockingInputStream.this.lockManager.readLock(SharedLockingInputStream.this.key.toString());
                    }
                    SharedLockingInputStream.this.fileLock = FileLocks.get().readLock(SharedLockingInputStream.this.file);
                    SharedLockingInputStream.this.stream = new BufferedInputStream(new FileInputStream(SharedLockingInputStream.this.file), AbstractBinaryStore.bestBufferSize(SharedLockingInputStream.this.file.length()));
                    SharedLockingInputStream.this.eofReached = false;
                }
                return null;
            }
        });
    }

    @Override
    public int available() throws IOException {
        return this.doOperation(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                if (SharedLockingInputStream.this.eofReached) {
                    return 0;
                }
                SharedLockingInputStream.this.open();
                return SharedLockingInputStream.this.stream.available();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            finally {
                this.stream = null;
                if (this.fileLock != null) {
                    try {
                        this.fileLock.unlock();
                    }
                    finally {
                        this.fileLock = null;
                        if (this.processLock != null) {
                            try {
                                this.processLock.unlock();
                            }
                            finally {
                                this.processLock = null;
                            }
                        }
                    }
                }
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof File) {
            return this.file.equals(obj);
        }
        if (obj instanceof BinaryKey) {
            return this.key.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public void mark(final int readlimit) {
        try {
            this.doOperation(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    SharedLockingInputStream.this.open();
                    if (SharedLockingInputStream.this.stream.markSupported()) {
                        SharedLockingInputStream.this.stream.mark(readlimit);
                    }
                    return null;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean markSupported() {
        try {
            return this.doOperation(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    SharedLockingInputStream.this.open();
                    return SharedLockingInputStream.this.stream.markSupported();
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int read(final byte[] b, final int off, final int len) throws IOException {
        return this.doOperation(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                if (SharedLockingInputStream.this.eofReached) {
                    return -1;
                }
                SharedLockingInputStream.this.open();
                int result = SharedLockingInputStream.this.stream.read(b, off, len);
                if (result == -1) {
                    SharedLockingInputStream.this.eofReached = true;
                    SharedLockingInputStream.this.close();
                }
                return result;
            }
        });
    }

    @Override
    public int read(final byte[] b) throws IOException {
        return this.doOperation(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                if (SharedLockingInputStream.this.eofReached) {
                    return -1;
                }
                SharedLockingInputStream.this.open();
                int result = SharedLockingInputStream.this.stream.read(b);
                if (result == -1) {
                    SharedLockingInputStream.this.eofReached = true;
                    SharedLockingInputStream.this.close();
                }
                return result;
            }
        });
    }

    @Override
    public int read() throws IOException {
        return this.doOperation(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                if (SharedLockingInputStream.this.eofReached) {
                    return -1;
                }
                SharedLockingInputStream.this.open();
                int result = SharedLockingInputStream.this.stream.read();
                if (result == -1) {
                    SharedLockingInputStream.this.eofReached = true;
                    SharedLockingInputStream.this.close();
                }
                return result;
            }
        });
    }

    @Override
    public void reset() throws IOException {
        this.doOperation(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SharedLockingInputStream.this.open();
                if (SharedLockingInputStream.this.stream.markSupported()) {
                    SharedLockingInputStream.this.stream.reset();
                }
                return null;
            }
        });
    }

    @Override
    public long skip(final long n) throws IOException {
        return this.doOperation(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                SharedLockingInputStream.this.open();
                return SharedLockingInputStream.this.stream.skip(n);
            }
        });
    }

    public String toString() {
        return this.key.toString();
    }

    private <T> T doOperation(Callable<T> streamOperation) throws IOException {
        try {
            return streamOperation.call();
        }
        catch (Throwable t) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new RuntimeException(t);
        }
    }
}

