/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.Objects;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.SecureHash;
import org.modeshape.jcr.value.Name;

@ThreadSafe
@Immutable
final class BucketId
implements Comparable<BucketId> {
    private final String id;

    protected BucketId(Name name, int length) {
        this(name.getString(), length);
    }

    protected BucketId(String nameString, int length) {
        String sha1 = SecureHash.sha1((String)nameString);
        this.id = sha1.substring(0, length);
    }

    protected BucketId(String id) {
        this.id = id;
    }

    @Override
    public int compareTo(BucketId o) {
        return this.id.compareTo(o.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BucketId bucketId = (BucketId)o;
        return Objects.equals(this.id, bucketId.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id;
    }
}

