/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.utils.glob;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xltest.utils.glob.FileMatcher;
import com.xebialabs.xltest.utils.glob.OverthereFileComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public final class Globbit {
    private Globbit() {
    }

    public static SortedSet<OverthereFile> find(OverthereFile root, FileMatcher matcher, GlobMode mode) {
        List<OverthereFile> allFilesAndDirectories = Globbit.recurseAllFilesAndDirectories(root);
        TreeSet<OverthereFile> matched = new TreeSet<OverthereFile>(new OverthereFileComparator());
        String fileSeparator = root.getConnection().getHostOperatingSystem().getFileSeparator();
        String workingDirectory = root.getPath() + fileSeparator;
        for (OverthereFile file : allFilesAndDirectories) {
            int indexOf;
            String path;
            String relativePath;
            String normalizedPath;
            boolean directory = file.isDirectory();
            if (mode == GlobMode.FILES_ONLY && directory || mode == GlobMode.DIRECTORIES_ONLY && !directory || !matcher.match(normalizedPath = (relativePath = (path = file.getPath()).substring(indexOf = path.indexOf(workingDirectory) + workingDirectory.length())).replace("\\", "/"))) continue;
            matched.add(file);
        }
        return matched;
    }

    private static List<OverthereFile> recurseAllFilesAndDirectories(OverthereFile file) {
        List overthereFiles;
        if (!file.isDirectory()) {
            return Collections.singletonList(file);
        }
        ArrayList<OverthereFile> result = new ArrayList<OverthereFile>();
        result.add(file);
        try {
            overthereFiles = file.listFiles();
        }
        catch (NullPointerException npe) {
            return Collections.emptyList();
        }
        for (OverthereFile child : overthereFiles) {
            result.addAll(Globbit.recurseAllFilesAndDirectories(child));
        }
        return result;
    }

    public static enum GlobMode {
        FILES_ONLY,
        DIRECTORIES_ONLY,
        FILES_AND_DIRECTORIES;

    }
}

