/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.upgrade.jcr;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.booter.local.PluginVersions;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.upgrade.Upgrader;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlplatform.upgrade.UpgraderHelper;
import com.xebialabs.xltest.Synthetic;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class XlTestViewUpgrader
extends Upgrader
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(XlTestViewUpgrader.class);
    private RepositoryVersionService repositoryVersionService;
    private final Set<String> components = Sets.newLinkedHashSet();
    private final ListMultimap<String, Upgrade> upgrades = ArrayListMultimap.create();
    @Autowired
    private RepositoryService repositoryService;

    public XlTestViewUpgrader(JcrTemplate jcrTemplate, RepositoryVersionService repositoryVersionService) {
        super(jcrTemplate, true, repositoryVersionService);
        this.repositoryVersionService = repositoryVersionService;
    }

    public void findAllPluginsAndUpgrades() {
        this.components.addAll(PluginVersions.getRegisteredPlugins());
        this.upgrades.putAll((Multimap)this.findUpgrades());
    }

    public boolean isUpgradePending() {
        this.findAllPluginsAndUpgrades();
        boolean result = false;
        for (String component : this.components) {
            if (!this.isUpgradePending(component)) continue;
            result = true;
        }
        if (result) {
            LOG.debug("Pending upgrades detected!");
        } else {
            LOG.debug("No pending upgrades detected!");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoUpgrade() {
        try {
            MDC.put((String)"logfile", (String)"upgrade");
            super.autoUpgrade();
        }
        finally {
            MDC.remove((String)"logfile");
        }
    }

    private boolean isUpgradePending(String component) {
        boolean hasPendingUpgrades;
        Version componentVersion;
        LOG.debug("Checking component [{}] for upgrades", (Object)component);
        try {
            componentVersion = this.repositoryVersionService.readVersionOfComponent(component);
        }
        catch (RuntimeException e) {
            LOG.warn(String.format("Component [%s] has an invalid version -- skipping upgrade", component), (Throwable)e);
            return false;
        }
        if (componentVersion == null) {
            LOG.debug("Skipping upgrade of component {} as it is not registered", (Object)component);
            return false;
        }
        LOG.debug("Component [{}] is at version [{}] in the repository", (Object)component, (Object)componentVersion);
        List componentUpgrades = UpgraderHelper.filterApplicable((List)this.upgrades.get((Object)component), (Version)componentVersion);
        boolean bl = hasPendingUpgrades = componentUpgrades.size() > 0;
        if (hasPendingUpgrades) {
            LOG.debug("Component [{}] has pending upgrades -> {}", (Object)component, (Object)componentUpgrades);
        } else {
            LOG.debug("Component [{}] has no pending upgrades.", (Object)component, (Object)componentVersion);
        }
        return hasPendingUpgrades;
    }

    private Version getLatestVersionOfComponent(String component) {
        List componentUpgrades = UpgraderHelper.filterApplicable((List)this.upgrades.get((Object)component), (Version)Version.valueOf((String)"xl-testview", (String)"0.0.0"));
        return ((Upgrade)componentUpgrades.get(componentUpgrades.size() - 1)).upgradeVersion();
    }

    public void afterPropertiesSet() throws Exception {
        this.findAllPluginsAndUpgrades();
        Version componentVersion = this.repositoryVersionService.readVersionOfComponent("xl-testview");
        if (componentVersion == null) {
            boolean basicDataHasBeenLoaded = this.repositoryService.exists(Synthetic.PROJECT.jcrDirectory);
            Version versionToStore = null;
            if (basicDataHasBeenLoaded) {
                versionToStore = Version.valueOf((String)"xl-testview", (String)"1.0.0");
                LOG.info("No component version exists, but data is present, creating initial version {}", (Object)versionToStore);
            } else {
                Version latestVersionOfComponent = this.getLatestVersionOfComponent("xl-testview");
                LOG.info("No component version exists, no basic data is loaded, creating initial version {}", (Object)latestVersionOfComponent);
                versionToStore = latestVersionOfComponent;
            }
            this.repositoryVersionService.storeVersionOfComponent(versionToStore);
        } else {
            LOG.info("Version {} for component {} found.", (Object)componentVersion, (Object)"xl-testview");
        }
    }
}

