/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import net.minidev.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
@Provider
@Produces(value={"application/json"})
public class JsonObjectMessageBodyWriter
implements MessageBodyWriter<JSONObject> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JSONObject.class.isAssignableFrom(type);
    }

    public long getSize(JSONObject jsonObject, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return jsonObject.toJSONString().length();
    }

    public void writeTo(JSONObject jsonObject, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(jsonObject.toJSONString().getBytes(StandardCharsets.UTF_8));
    }
}

