/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.repository;

import com.google.common.base.CaseFormat;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import com.jayway.jsonpath.spi.JsonProvider;
import com.jayway.jsonpath.spi.JsonProviderFactory;
import com.xebialabs.xlt.plugin.api.testrun.Event;
import com.xebialabs.xlt.plugin.api.testrun.EventValidator;
import com.xebialabs.xltest.repository.EventRepository;
import com.xebialabs.xltest.service.EventBulkProcessor;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequestBuilder;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.deletebyquery.DeleteByQueryRequestBuilder;
import org.elasticsearch.action.deletebyquery.DeleteByQueryResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.FilteredQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class EventRepositoryImpl
implements EventRepository,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(EventRepositoryImpl.class);
    public static final String INDEX_XLTEST = "xltest";
    public static final String ELASTICSEARCH_DEFAULT_INDEX_CONFIGURATION = "elasticsearch/index-defaults.json";
    public static final List<String> EVENT_TYPES = ImmutableList.of((Object)"childFinished", (Object)"executionStarted", (Object)"executionFinished", (Object)"importStarted", (Object)"childStarted", (Object)"functionalResult", (Object)"importFinished");
    private static final FieldSortBuilder SORT_TIMESTAMP_ASC = SortBuilders.fieldSort((String)"@createdAt").order(SortOrder.ASC).unmappedType("long");
    private static final FieldSortBuilder SORT_TIMESTAMP_DESC = SortBuilders.fieldSort((String)"@createdAt").order(SortOrder.DESC).unmappedType("long");
    private final Client client;

    public EventRepositoryImpl(Client client) {
        this.client = client;
    }

    public void afterPropertiesSet() throws Exception {
        this.configureIndex();
    }

    public String getResourceAsString(String resourcePath) throws IOException {
        URL url = Resources.getResource((String)resourcePath);
        return Resources.toString((URL)url, (Charset)Charsets.UTF_8);
    }

    public void configureIndex() throws InterruptedException, ExecutionException, IOException {
        if (this.existsXlTestIndex()) {
            return;
        }
        LOG.info("Configuring Elasticsearch indices");
        Settings indexSettings = ImmutableSettings.settingsBuilder().build();
        PutIndexTemplateRequestBuilder putTemplate = this.client.admin().indices().preparePutTemplate("default-index-template").setTemplate("*").setOrder(0).setSettings(indexSettings);
        URL url = Resources.getResource((String)ELASTICSEARCH_DEFAULT_INDEX_CONFIGURATION);
        String cfg = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        LOG.debug("Default mappings for indices: {}", (Object)cfg);
        putTemplate.addMapping("_default_", cfg);
        putTemplate.execute().actionGet();
        try {
            CreateIndexRequest cir = Requests.createIndexRequest((String)INDEX_XLTEST);
            for (String evenType : EVENT_TYPES) {
                String hyphenized = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, evenType);
                String fileName = String.format("elasticsearch/%s-mapping.json", hyphenized);
                try {
                    String mapping = this.getResourceAsString(fileName);
                    LOG.info("Adding mapping for '{}' from '{}'", (Object)evenType, (Object)fileName);
                    cir.mapping(evenType, mapping);
                }
                catch (IllegalArgumentException e) {
                    LOG.debug("No mapping for: {}", (Object)evenType);
                }
            }
            this.client.admin().indices().create(cir).actionGet();
        }
        catch (IndexAlreadyExistsException e) {
            LOG.info("Index '{}' already existed", (Object)INDEX_XLTEST);
        }
    }

    @Override
    public Event findById(String id) {
        IdsQueryBuilder b = QueryBuilders.idsQuery((String[])new String[0]).addIds(new String[]{id});
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{INDEX_XLTEST}).setQuery((QueryBuilder)b).execute().actionGet();
        SearchHits hits = response.getHits();
        if (hits.getTotalHits() > 1L) {
            throw new IllegalStateException("Multiple events found with the same id " + id);
        }
        if (hits.getTotalHits() == 1L) {
            SearchHit hit = hits.getAt(0);
            return this.parseElasticSearchHit(hit);
        }
        return null;
    }

    public void bulkInsert(Collection<Event> events, boolean refresh) {
        if (events.isEmpty()) {
            return;
        }
        BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk();
        bulkRequestBuilder.setRefresh(refresh);
        for (Event event : events) {
            String json = this.createJsonForEvent(event);
            bulkRequestBuilder.add(new IndexRequest(INDEX_XLTEST, event.getType()).source(json));
        }
        ListenableActionFuture execute = bulkRequestBuilder.execute();
        this.waitUntilDone(refresh, (ActionFuture<? extends ActionResponse>)execute);
    }

    public void bulkUpdate(Collection<Event> events, boolean refresh) {
        if (events.isEmpty()) {
            return;
        }
        BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk();
        bulkRequestBuilder.setRefresh(refresh);
        for (Event event : events) {
            String json = this.createJsonForEvent(event);
            bulkRequestBuilder.add(new UpdateRequest(INDEX_XLTEST, event.getType(), event.getId()).doc(json));
        }
        ListenableActionFuture execute = bulkRequestBuilder.execute();
        this.waitUntilDone(refresh, (ActionFuture<? extends ActionResponse>)execute);
    }

    @Override
    public void bulkUpdate(String query, int size, EventBulkProcessor eventBulkProcessor) {
        int bulkSize;
        SearchRequestBuilder searchRequestBuilder = this.client.prepareSearch(new String[]{INDEX_XLTEST}).setSearchType(SearchType.SCAN).setScroll(TimeValue.timeValueMinutes((long)1L)).setFrom(0).setSize(size);
        if (!Strings.isNullOrEmpty((String)query)) {
            QueryStringQueryBuilder queryStringQueryBuilder = QueryBuilders.queryStringQuery((String)query);
            searchRequestBuilder.setQuery((QueryBuilder)queryStringQueryBuilder);
        }
        SearchResponse response = (SearchResponse)searchRequestBuilder.execute().actionGet();
        long processed = 0L;
        do {
            response = (SearchResponse)this.client.prepareSearchScroll(response.getScrollId()).setScroll(TimeValue.timeValueMinutes((long)1L)).execute().actionGet();
            SearchHits hits = response.getHits();
            ArrayList<Event> all = new ArrayList<Event>();
            for (SearchHit hit : hits) {
                all.add(this.parseElasticSearchHit(hit));
            }
            eventBulkProcessor.process(all);
            bulkSize = all.size();
            int percentage = (int)((processed += (long)bulkSize) * 100L / (hits.getTotalHits() + 1L));
            if (Strings.isNullOrEmpty((String)query)) {
                LOG.info("bulkUpdate without query is processing {} of {} (at {}%) results with processor {}", new Object[]{processed, hits.totalHits(), percentage, eventBulkProcessor.getClass().getSimpleName()});
                continue;
            }
            LOG.info("bulkUpdate with query [{}] is processing {} of {} (at {}%) results with processor {}", new Object[]{query, processed, hits.totalHits(), percentage, eventBulkProcessor.getClass().getSimpleName()});
        } while (bulkSize != 0);
    }

    @Override
    public void insert(Event event) {
        this.insert(event, false);
    }

    @Override
    public void insert(Event event, boolean refresh) {
        this.insertWithTypeField("@type", event, refresh);
    }

    @Override
    public void insertWithTypeField(String eventTypeField, Event event, boolean refresh) {
        LOG.trace("insert: event='{}' refresh={}", (Object)event, (Object)refresh);
        String content = this.createJsonForEvent(event);
        this.insert((String)event.get(eventTypeField), content, refresh);
    }

    @Override
    public void insert(Collection<Event> events) {
        this.bulkInsert(events, false);
    }

    @Override
    public void insert(Collection<Event> events, boolean refresh) {
        for (Event event : events) {
            this.insert(event, refresh);
        }
    }

    @Override
    public void insertRun(List<Event> events) {
        EventValidator.validateRun(events);
        this.insert(events);
    }

    private void insert(String type, String json, boolean refresh) {
        IndexRequestBuilder indexRequestBuilder = this.client.prepareIndex(INDEX_XLTEST, type);
        indexRequestBuilder.setRefresh(refresh);
        ListenableActionFuture execute = indexRequestBuilder.setSource(json).execute();
        this.waitUntilDone(refresh, (ActionFuture<? extends ActionResponse>)execute);
    }

    @Override
    public void update(Event event, boolean refresh) {
        Preconditions.checkNotNull((Object)event.getId());
        String content = this.createJsonForEvent(event);
        IndexRequestBuilder indexRequestBuilder = this.client.prepareIndex(INDEX_XLTEST, event.getType());
        indexRequestBuilder.setId(event.getId());
        indexRequestBuilder.setRefresh(refresh);
        ListenableActionFuture execute = indexRequestBuilder.setSource(content).execute();
        this.waitUntilDone(refresh, (ActionFuture<? extends ActionResponse>)execute);
    }

    @Override
    public void updateAndPersist(Event event) {
        Preconditions.checkNotNull((Object)event.getId());
        String content = this.createJsonForEvent(event);
        IndexRequestBuilder indexRequestBuilder = this.client.prepareIndex(INDEX_XLTEST, event.getType());
        indexRequestBuilder.setId(event.getId());
        ListenableActionFuture execute = indexRequestBuilder.setSource(content).execute();
        execute.actionGet();
    }

    @Override
    public void update(Event event) {
        this.update(event, false);
    }

    @Override
    public void update(Collection<Event> events) {
        this.update(events, false);
    }

    @Override
    public void update(Collection<Event> events, boolean refresh) {
        this.bulkUpdate(events, refresh);
    }

    @Override
    public List<Event> query(String query) {
        LOG.trace("query: {}", (Object)query);
        QueryStringQueryBuilder b = QueryBuilders.queryStringQuery((String)query);
        return this.query((QueryBuilder)b);
    }

    @Override
    public List<Event> query(QueryBuilder b) {
        return this.query(b, (SortBuilder)SORT_TIMESTAMP_ASC, 100000);
    }

    @Override
    public List<Event> query(FilterBuilder fb) {
        LOG.trace("query(): {}", (Object)fb);
        FilteredQueryBuilder qb = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)fb);
        return this.query((QueryBuilder)qb);
    }

    @Override
    public List<Event> query(FilterBuilder filterBuilder, SortBuilder sortBuilder, int size) {
        LOG.trace("query(): filter={}, sort={} size={}", new Object[]{filterBuilder, sortBuilder, size});
        FilteredQueryBuilder queryBuilder = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)filterBuilder);
        return this.query((QueryBuilder)queryBuilder, sortBuilder, size);
    }

    @Override
    public List<Event> query(QueryBuilder queryBuilder, SortBuilder sortBuilder, int size) {
        ArrayList<Event> all = new ArrayList<Event>();
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{INDEX_XLTEST}).setQuery(queryBuilder).addSort(sortBuilder).setFrom(0).setSize(size).execute().actionGet();
        SearchHits hits = response.getHits();
        for (SearchHit hit : hits) {
            all.add(this.parseElasticSearchHit(hit));
        }
        return all;
    }

    @Override
    public ListenableActionFuture<DeleteByQueryResponse> delete(QueryBuilder qb) {
        DeleteByQueryRequestBuilder deleteByQueryRequestBuilder = this.client.prepareDeleteByQuery(new String[]{INDEX_XLTEST});
        deleteByQueryRequestBuilder.setQuery(qb);
        ListenableActionFuture future = deleteByQueryRequestBuilder.execute();
        return future;
    }

    @Override
    public ListenableActionFuture<DeleteByQueryResponse> delete(FilterBuilder fb) {
        FilteredQueryBuilder qb = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)fb);
        return this.delete((QueryBuilder)qb);
    }

    @Override
    public Event fetchLatest(FilterBuilder b) {
        SearchHits hits;
        try {
            SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{INDEX_XLTEST}).setQuery((QueryBuilder)QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)b)).setSize(1).addSort((SortBuilder)SORT_TIMESTAMP_DESC).execute().actionGet();
            hits = response.getHits();
        }
        catch (SearchPhaseExecutionException e) {
            LOG.warn("Could not execute elasticSearch query", (Throwable)e);
            return null;
        }
        if (hits.getTotalHits() >= 1L) {
            return this.parseElasticSearchHit(hits.getAt(0));
        }
        return null;
    }

    @Override
    public Event fetchLatest(String testSpecificationName, String eventType) {
        return this.fetchLatest((FilterBuilder)FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.termFilter((String)"@type", (String)eventType), FilterBuilders.termFilter((String)"@testSpecification", (String)testSpecificationName)}));
    }

    @Override
    public long countAll() {
        ListenableActionFuture execute = this.client.prepareCount(new String[]{INDEX_XLTEST}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute();
        this.waitUntilDone(true, (ActionFuture<? extends ActionResponse>)execute);
        long count = ((CountResponse)execute.actionGet()).getCount();
        LOG.trace("countAll: {} events in the repository", (Object)count);
        return count;
    }

    @Override
    public ListenableActionFuture<DeleteResponse> delete(String type, String id) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)type) ? 1 : 0) != 0, (Object)"Type is required");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"Id is required");
        DeleteRequestBuilder deleteRequestBuilder = this.client.prepareDelete(INDEX_XLTEST, type, id);
        return deleteRequestBuilder.execute();
    }

    @Override
    public void refreshIndex() {
        this.client.admin().indices().prepareRefresh(new String[0]).execute().actionGet();
    }

    @Override
    public void updateMapping(String documentType, String propertyName, Map<String, Object> properties) {
        LOG.info("updateMapping: type={} property={} properties={}", new Object[]{documentType, propertyName, properties});
        PutMappingRequestBuilder putMappingRequestBuilder = this.client.admin().indices().preparePutMapping(new String[]{INDEX_XLTEST});
        try {
            XContentBuilder mappingBuilder = XContentFactory.jsonBuilder().startObject().startObject(documentType).startObject("properties").startObject(propertyName);
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                mappingBuilder.field(entry.getKey(), entry.getValue());
            }
            mappingBuilder.endObject().endObject().endObject().endObject();
            PutMappingResponse putMappingResponse = (PutMappingResponse)putMappingRequestBuilder.setIgnoreConflicts(false).setType(documentType).setSource(mappingBuilder).execute().actionGet();
            LOG.info("UpdateMapping acknowledged={}", (Object)putMappingResponse.isAcknowledged());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to update mapping", e);
        }
    }

    private Event parseElasticSearchHit(SearchHit hit) {
        return new Event(hit.getSource()).update("_id", (Object)hit.getId());
    }

    public boolean deleteIndex(boolean block) {
        ActionFuture delete = this.client.admin().indices().delete(new DeleteIndexRequest(INDEX_XLTEST));
        this.waitUntilDone(block, (ActionFuture<? extends ActionResponse>)delete);
        return ((DeleteIndexResponse)delete.actionGet()).isAcknowledged();
    }

    private boolean existsXlTestIndex() {
        return ((IndicesExistsResponse)this.client.admin().indices().exists(new IndicesExistsRequest(new String[]{INDEX_XLTEST})).actionGet()).isExists();
    }

    private void waitUntilDone(boolean block, ActionFuture<? extends ActionResponse> execute) {
        if (block) {
            execute.actionGet();
        }
    }

    private String createJsonForEvent(Event event) {
        JsonProvider jsonProvider = JsonProviderFactory.createProvider();
        return jsonProvider.toJson((Object)event.getProperties());
    }
}

