/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xlt.plugin.api.testrun.Event;
import com.xebialabs.xlt.plugin.api.testrun.TestRunsRepository;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.domain.QualificationResult;
import com.xebialabs.xltest.domain.Qualifier;
import com.xebialabs.xltest.domain.ScriptedConfigurationItem;
import com.xebialabs.xltest.domain.TestRunImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.script.ScriptContext;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(description="Base type for test run qualifiers.", root=Metadata.ConfigurationItemRoot.CONFIGURATION, versioned=false)
public class Qualification
extends ScriptedConfigurationItem {
    private static final Logger LOG = LoggerFactory.getLogger(Qualification.class);

    public static Qualification getQualificationFor(String qualificationType) {
        Preconditions.checkNotNull((Object)qualificationType);
        return (Qualification)DescriptorRegistry.getDescriptor((String)qualificationType).newInstance(UUID.randomUUID().toString());
    }

    public Qualifier getQualifier(final BaseTestSpecification testSpecification, final String testRunId, final TestRunsRepository testRunsRepository) {
        return new Qualifier(){

            @Override
            public QualificationResult getQualificationResult(List<Event> events) {
                QualificationResult qualificationResult = QualificationResult.newInstance(testSpecification, testRunId);
                if (events.isEmpty()) {
                    qualificationResult.setResult(QualificationResult.Result.FAILED);
                    qualificationResult.setTime(DateTime.now().toDate());
                    qualificationResult.addFailureReason("No events have been found");
                }
                ScriptContext context = Qualification.this.newScriptContext();
                context.setAttribute("events", events, 100);
                context.setAttribute("test_run", new TestRunImpl(events), 100);
                context.setAttribute("test_runs", testRunsRepository, 100);
                testRunsRepository.refreshIndex();
                try {
                    LinkedHashMap result = new LinkedHashMap((Map)Qualification.this.execute(context, Qualification.this));
                    Boolean success = (Boolean)result.remove("success");
                    String reason = (String)result.remove("reason");
                    HashMap<String, String> otherProperties = new HashMap<String, String>();
                    for (Map.Entry entry : result.entrySet()) {
                        otherProperties.put((String)entry.getKey(), entry.getValue().toString());
                    }
                    qualificationResult.setOtherProperties(otherProperties);
                    qualificationResult.setResult(Qualification.this.toResult(success));
                    if (reason != null) {
                        qualificationResult.setFailureReason(Collections.singletonList(reason));
                    }
                }
                catch (Exception e) {
                    LOG.warn("Unable to calculate qualification for test run {}: {}", (Object)testRunId, (Object)e.getMessage());
                    LOG.debug("Qualification calculation error", (Throwable)e);
                    qualificationResult.setResult(QualificationResult.Result.FAILED);
                    qualificationResult.setFailureReason(Collections.singletonList("Could not calculate qualification: " + e.getMessage()));
                }
                qualificationResult.setTime(DateTime.now().toDate());
                return qualificationResult;
            }
        };
    }

    private QualificationResult.Result toResult(Boolean success) {
        if (success == null) {
            return QualificationResult.Result.FAILED;
        }
        if (success.booleanValue()) {
            return QualificationResult.Result.PASSED;
        }
        return QualificationResult.Result.FAILED;
    }
}

