/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api.v1;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.domain.QualificationResult;
import com.xebialabs.xltest.repository.TestSpecificationRepository;
import java.util.LinkedHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/api/v1/qualifications")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@NoCache
public class QualificationController {
    public static final String MESSAGE = "message";
    public static final String RESULT = "result";
    private static final String TIME = "time";
    private static final String STATUS = "status";
    private final TestSpecificationRepository testSpecificationRepository;

    @Autowired
    public QualificationController(TestSpecificationRepository testSpecificationRepository) {
        this.testSpecificationRepository = testSpecificationRepository;
    }

    @Path(value="/")
    @GET
    public Response getQualificationByName(@QueryParam(value="testSpecification") String testSpecification, @Context UriInfo uriInfo) {
        if (Strings.isNullOrEmpty((String)testSpecification)) {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            result.put(MESSAGE, "A test specification is required in the testSpecification query parameter");
            result.put(STATUS, "400");
            result.put("error_code", "object.not.found");
            return Response.status((int)400).entity(result).build();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        BaseTestSpecification testSpec = this.testSpecificationRepository.get(testSpecification);
        Optional<QualificationResult> qualificationResult = this.testSpecificationRepository.getLatestQualificationResult(testSpec);
        if (!qualificationResult.isPresent() && !testSpec.hasQualificationType()) {
            return Response.noContent().build();
        }
        if (!qualificationResult.isPresent()) {
            result.put(RESULT, false);
            result.put(MESSAGE, "No results available for this test specification");
            result.put("error_code", "no.qualification.results");
            return Response.status((int)200).entity(result).build();
        }
        switch (((QualificationResult)((Object)qualificationResult.get())).getResult()) {
            case PASSED: {
                result.put(RESULT, true);
                result.put(MESSAGE, ((QualificationResult)((Object)qualificationResult.get())).getLastFailureReason());
                result.put(TIME, ((QualificationResult)((Object)qualificationResult.get())).getTime().toString());
                return Response.ok(result).build();
            }
            case FAILED: {
                result.put(RESULT, false);
                result.put(MESSAGE, ((QualificationResult)((Object)qualificationResult.get())).getLastFailureReason());
                result.put(TIME, ((QualificationResult)((Object)qualificationResult.get())).getTime().toString());
                return Response.ok(result).build();
            }
        }
        throw new RuntimeException("Forgot to implement case: " + (Object)((Object)((QualificationResult)((Object)qualificationResult.get())).getResult()));
    }
}

