/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api.internal;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.domain.DashboardTile;
import com.xebialabs.xltest.domain.Project;
import com.xebialabs.xltest.repository.DashboardRepository;
import com.xebialabs.xltest.repository.ProjectRepository;
import com.xebialabs.xltest.repository.TestSpecificationRepository;
import com.xebialabs.xltest.serialize.CiDepth;
import com.xebialabs.xltest.serialize.TestSpecificationStatusStream;
import com.xebialabs.xltest.serialize.TestSpecificationTreeBuilder;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONException;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;

@Controller
@Path(value="/api/internal/projects")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@NoCache
public class ProjectController {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectController.class);
    private final ProjectRepository projectRepository;
    private final DashboardRepository dashboardRepository;
    private final TestSpecificationRepository testSpecificationRepository;
    private final TestSpecificationTreeBuilder testSpecificationTreeBuilder;
    private final TestSpecificationStatusStream testSpecificationStatusStream;

    @Autowired
    public ProjectController(ProjectRepository projectRepository, DashboardRepository dashboardRepository, TestSpecificationRepository testSpecificationRepository, TestSpecificationTreeBuilder testSpecificationTreeBuilder, TestSpecificationStatusStream testSpecificationStatusStream) {
        this.projectRepository = projectRepository;
        this.dashboardRepository = dashboardRepository;
        this.testSpecificationRepository = testSpecificationRepository;
        this.testSpecificationTreeBuilder = testSpecificationTreeBuilder;
        this.testSpecificationStatusStream = testSpecificationStatusStream;
    }

    @GET
    @Path(value="/")
    @CiDepth(value=1)
    public List<Project> getProjects() {
        List<Project> projects = this.projectRepository.getProjects();
        Collections.sort(projects, Project.titleComparator);
        return projects;
    }

    @POST
    @Path(value="/")
    public Response createProject(BaseConfigurationItem item) {
        Project project = this.projectRepository.createProject((Project)item);
        LOG.debug("createProject: id = {}", (Object)project.getId());
        return Response.status((int)201).entity((Object)project).build();
    }

    @PUT
    @Path(value="/{projectName:.+}")
    public void updateProject(@PathParam(value="projectName") String projectName, Project item) {
        this.projectRepository.update(item);
    }

    @GET
    @Path(value="/{projectName:.+}")
    public Project getProject(@PathParam(value="projectName") String projectName) {
        return this.projectRepository.getProject(projectName);
    }

    @DELETE
    @Path(value="/{projectName:.+}")
    public void delete(@PathParam(value="projectName") String projectName, @QueryParam(value="newProjectName") String newProjectName) {
        if (StringUtils.hasText((String)newProjectName)) {
            this.projectRepository.moveAllTestSpecifications(projectName, newProjectName);
        }
        this.projectRepository.delete(projectName);
    }

    @PUT
    @Path(value="/{projectName:.+}/testspecifications")
    public Response updateSpecificationForProject(@PathParam(value="projectName") String projectName, BaseTestSpecification item) {
        switch (this.projectRepository.updateSpecification(projectName, item.getName(), item)) {
            case MOVED: {
                return Response.ok().entity((Object)item).build();
            }
            case UPDATED: {
                return Response.noContent().build();
            }
        }
        return Response.status((int)400).build();
    }

    @POST
    @Path(value="/{projectName:.+}/testspecifications")
    public Response createSpecificationForProject(@PathParam(value="projectName") String projectName, BaseTestSpecification item) {
        BaseTestSpecification newSpec = this.projectRepository.createSpecificationForProject(projectName, item);
        return Response.status((int)201).entity((Object)newSpec).build();
    }

    @GET
    @Path(value="/{projectName:.+}/testspecifications")
    public String getTestSpecificationsStatusesForProject(@PathParam(value="projectName") String projectName) throws JSONException {
        return this.testSpecificationTreeBuilder.treeForTestSpecification(projectName).toString();
    }

    @GET
    @Path(value="/{projectName:.+}/testspecifications/{testSpecificationId:.+}")
    public BaseConfigurationItem getTestSpecification(@PathParam(value="projectName") String projectName, @PathParam(value="testSpecificationId") String testSpecificationId) throws JSONException {
        return this.testSpecificationRepository.getSpecificationForProject(projectName, testSpecificationId);
    }

    @GET
    @Path(value="/{projectName:.+}/status")
    @Produces(value={"text/event-stream"})
    public void getTestSpecificationsStatusesForProject(@PathParam(value="projectName") String projectName, @Context HttpServletResponse response) throws Exception {
        response.setContentType("text/event-stream");
        response.setCharacterEncoding("UTF-8");
        response.addHeader("Cache-Control", "no-cache");
        response.addHeader("Connection", "keep-alive");
        PrintWriter writer = response.getWriter();
        this.testSpecificationStatusStream.getSpecificationStatuses(projectName, writer);
    }

    @GET
    @Path(value="/{projectName:.+}/testspecifications/{testSpecificationId:.+}/reports")
    public Response findReportsForTestSpecification(@PathParam(value="projectName") String projectName, @PathParam(value="testSpecificationId") String testSpecificationId) {
        BaseTestSpecification testSpecification = this.testSpecificationRepository.getSpecificationForProject(projectName, testSpecificationId);
        List<Descriptor> reportsForTestSpecification = this.testSpecificationRepository.findReportsForTestSpecification(testSpecification);
        ArrayList simpleDescriptors = Lists.newArrayList((Iterable)Collections2.transform(reportsForTestSpecification, (Function)new Function<Descriptor, SimpleDescriptor>(){

            public SimpleDescriptor apply(Descriptor input) {
                return new SimpleDescriptor(input);
            }
        }));
        Collections.sort(simpleDescriptors);
        return Response.ok((Object)simpleDescriptors).build();
    }

    @DELETE
    @Path(value="/{projectName:.+}/testspecifications/{testSpecificationName:.+}")
    public Response deleteTestSpecification(@PathParam(value="projectName") String projectName, @PathParam(value="testSpecificationName") String testSpecificationName, @QueryParam(value="dryRun") boolean dryRun) {
        if (!dryRun) {
            this.testSpecificationRepository.deleteTestSpecification(projectName, testSpecificationName);
            return Response.noContent().build();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("dashboardTiles", this.groupByDashboard(this.dashboardRepository.findDashboardTilesBySpecificationName(testSpecificationName)));
        result.put("testSpecificationSets", this.testSpecificationRepository.findTestSpecificationSetsForSpecification(testSpecificationName));
        return Response.ok(result).build();
    }

    private Map<String, List<DashboardTile>> groupByDashboard(List<DashboardTile> dashboardTiles) {
        HashMap<String, List<DashboardTile>> result = new HashMap<String, List<DashboardTile>>();
        for (DashboardTile dashboardTile : dashboardTiles) {
            String dashboardTitle = this.dashboardRepository.getById(dashboardTile.getDashboardId()).getTitle();
            if (result.get(dashboardTitle) == null) {
                result.put(dashboardTitle, new ArrayList());
            }
            ((List)result.get(dashboardTitle)).add(dashboardTile);
        }
        return result;
    }

    @DELETE
    @Path(value="/{projectName:.+}/testspecifications/{testSpecificationName:.+}/{testSpecificationParentId:.+}")
    public void deleteTestSpecificationReferenceFromParent(@PathParam(value="projectName") String projectName, @PathParam(value="testSpecificationName") String testSpecificationName, @PathParam(value="testSpecificationParentId") String testSpecificationParentId) {
        this.testSpecificationRepository.deleteTestSpecificationReferenceFromParent(projectName, testSpecificationName, testSpecificationParentId);
    }

    static final class SimpleDescriptor
    implements Comparable<SimpleDescriptor> {
        public String type;
        public String title;
        public String userFriendlyDescription;
        public String iconName;

        public SimpleDescriptor(Descriptor descriptor) {
            this.type = descriptor.getType().toString();
            this.title = descriptor.getLabel();
            this.userFriendlyDescription = descriptor.getDescription();
            this.iconName = descriptor.getPropertyDescriptor("iconName").getDefaultValue().toString();
        }

        @Override
        public int compareTo(SimpleDescriptor o) {
            return ComparisonChain.start().compare((Comparable)((Object)this.title), (Comparable)((Object)o.title)).compare((Comparable)((Object)this.type), (Comparable)((Object)o.type)).compare((Comparable)((Object)this.userFriendlyDescription), (Comparable)((Object)o.userFriendlyDescription)).compare((Comparable)((Object)this.iconName), (Comparable)((Object)o.iconName)).result();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleDescriptor that = (SimpleDescriptor)o;
            return Objects.equals(this.type, that.type) && Objects.equals(this.title, that.title) && Objects.equals(this.userFriendlyDescription, that.userFriendlyDescription) && Objects.equals(this.iconName, that.iconName);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.title, this.userFriendlyDescription, this.iconName);
        }
    }
}

