/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest;

import ch.qos.logback.access.jetty.RequestLogImpl;
import com.google.common.base.Throwables;
import com.typesafe.config.Config;
import com.xebialabs.deployit.jetty.DeployitSpringContextLoaderListener;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.license.LicenseRegistrationServlet;
import com.xebialabs.license.LicenseValidationFilter;
import com.xebialabs.xltest.DataLoader;
import com.xebialabs.xltest.SlowdownFilter;
import com.xebialabs.xltest.SystemProperties;
import com.xebialabs.xltest.XLTestErrorPageHandler;
import com.xebialabs.xltest.XlTestState;
import com.xebialabs.xltest.api.AllowAccessWhenDoneBootingFilter;
import com.xebialabs.xltest.configuration.BootstrapConfiguration;
import com.xebialabs.xltest.configuration.SpringContextHolder;
import com.xebialabs.xltest.utils.SecurityUtils;
import java.lang.management.ManagementFactory;
import java.security.Provider;
import java.security.Security;
import java.util.Collection;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.concurrent.TimeUnit;
import javax.servlet.DispatcherType;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.session.HashSessionIdManager;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.filter.DelegatingFilterProxy;

public class XLTest {
    private static final Logger LOG = LoggerFactory.getLogger(XLTest.class);
    private Server server;
    private boolean forceUpgrades = false;
    public static XlTestState state = XlTestState.INITIAL;
    private final Config config = SystemProperties.getConfig();

    public XLTest(boolean forceUpgrades) {
        this.forceUpgrades = forceUpgrades;
    }

    public void startWebApp() throws Exception {
        org.jboss.resteasy.logging.Logger.setLoggerType((Logger.LoggerType)Logger.LoggerType.SLF4J);
        this.setState(XlTestState.BOOTING);
        this.startWebApp(this.webAppBindAddress(), this.webAppPortNumber(), "production");
    }

    public void startWebApp(String host, Integer port, String profile) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SecurityUtils.configureTrustStore(this.config);
        System.setProperty("spring.profiles.default", profile);
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMinThreads(this.config.getInt("xlt.server.threadpool.min"));
        threadPool.setMaxThreads(this.config.getInt("xlt.server.threadpool.max"));
        this.server = new Server((ThreadPool)threadPool);
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(port.intValue());
        connector.setHost(host);
        Collection cfs = connector.getConnectionFactories();
        for (ConnectionFactory cf : cfs) {
            if (!(cf instanceof HttpConnectionFactory)) continue;
            ((HttpConnectionFactory)cf).getHttpConfiguration().setSendServerVersion(false);
        }
        this.server.setConnectors(new Connector[]{connector});
        HandlerCollection handlers = new HandlerCollection();
        WebAppContext webAppContext = this.createWebAppContext();
        handlers.addHandler((Handler)webAppContext);
        handlers.addHandler((Handler)new StatisticsHandler());
        this.server.setHandler((Handler)handlers);
        MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        this.server.addEventListener((Container.Listener)mbContainer);
        this.server.addBean((Object)mbContainer);
        try {
            this.server.start();
            this.setSessionTimeout(webAppContext);
            this.server.setStopAtShutdown(true);
            DeployitSpringContextLoaderListener.checkCorrectlyInitialized();
            DataLoader dataLoader = new DataLoader(SpringContextHolder.getRepositoryService(), SpringContextHolder.getElasticSearchClient(), SpringContextHolder.getEventRepository());
            if (this.forceUpgrades) {
                LOG.info("Force upgrade flag set. Trying to apply upgrades if applicable.");
                this.setState(XlTestState.UPGRADING);
                SpringContextHolder.xlTestViewUpgrader().autoUpgrade();
            } else {
                LOG.info("Force upgrade flag *not* set. Checking for pending upgrades first.");
                try {
                    this.setState(XlTestState.CHECKING_FOR_UPGRADES);
                    if (SpringContextHolder.xlTestViewUpgrader().isUpgradePending()) {
                        LOG.error("There are pending upgrades. Please execute the upgrade task first before starting XL TestView");
                        throw new IllegalStateException("There are pending upgrades. Please execute the upgrade task first before starting XL TestView");
                    }
                }
                catch (UpgradeException e) {
                    LOG.error("There are pending upgrades. Please execute the upgrade task first before starting XL TestView");
                    throw new IllegalStateException("There are pending upgrades. Please execute the upgrade task first before starting XL TestView");
                }
            }
            if (dataLoader.loadBasicData() && SpringContextHolder.loadDemoData()) {
                this.setState(XlTestState.GENERATING_DEMODATA);
                dataLoader.loadDemoData("demodata/generate.py");
            }
            this.setState(XlTestState.RUNNING);
        }
        catch (RuntimeException e) {
            this.setState(XlTestState.SHUTTING_DOWN);
            this.server.stop();
            LOG.error("Error while running webapp: {} ", (Object)Throwables.getStackTraceAsString((Throwable)e));
            throw e;
        }
    }

    private void setSessionTimeout(WebAppContext webAppContext) {
        webAppContext.getSessionHandler().getSessionManager().setMaxInactiveInterval((int)this.config.getDuration("xlt.server.session-timeout", TimeUnit.SECONDS));
    }

    private void setState(XlTestState desiredState) {
        LOG.debug("XLTestView state updated from {} to {} ", (Object)state, (Object)desiredState);
        state = desiredState;
    }

    public String webAppBindAddress() {
        return this.config.getString("xlt.server.host");
    }

    private String getContextPath() {
        return this.config.getString("xlt.server.root");
    }

    public int webAppPortNumber() {
        return this.config.getInt("xlt.server.port");
    }

    public void stopWebApp() throws Exception {
        this.setState(XlTestState.SHUTTING_DOWN);
        this.server.stop();
        this.server.join();
    }

    public void join() throws InterruptedException {
        this.server.join();
    }

    private WebAppContext createWebAppContext() {
        WebAppContext context = new WebAppContext();
        XLTestErrorPageHandler handler = new XLTestErrorPageHandler();
        handler.setShowStacks(false);
        if (this.config.getBoolean("xlt.dev-mode")) {
            LOG.info("Running in development mode, showing stack traces in Jetty Error pages");
            handler.setShowStacks(true);
        }
        context.setErrorHandler((ErrorHandler)handler);
        context.setContextPath(this.getContextPath());
        context.setInitParameter("contextConfigLocation", BootstrapConfiguration.class.getName());
        context.setInitParameter("contextClass", AnnotationConfigWebApplicationContext.class.getName());
        context.addEventListener((EventListener)new ResteasyBootstrap());
        context.addEventListener((EventListener)new DeployitSpringContextLoaderListener());
        context.setResourceBase(".");
        int slowDownInMs = this.config.getInt("xlt.filters.slowdown");
        if (slowDownInMs > 0) {
            LOG.warn("Configuring slow down filter with {} milliseconds.", (Object)slowDownInMs);
            FilterHolder slowdownFilter = new FilterHolder(SlowdownFilter.class);
            slowdownFilter.setInitParameter("ms", String.valueOf(slowDownInMs));
            context.addFilter(slowdownFilter, "/api/*", EnumSet.of(DispatcherType.REQUEST));
        }
        FilterHolder licenseValidationFilter = new FilterHolder(LicenseValidationFilter.class);
        licenseValidationFilter.setInitParameter("whiteListedPaths", "/api/internal/license,/api/internal/license/reload,/api/v1/info");
        context.addFilter(licenseValidationFilter, "/api/*", EnumSet.of(DispatcherType.REQUEST));
        context.addFilter(AllowAccessWhenDoneBootingFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        FilterHolder filter = new FilterHolder(DelegatingFilterProxy.class);
        filter.setName("springSecurityFilterChain");
        context.addFilter(filter, "/*", EnumSet.of(DispatcherType.REQUEST));
        ServletHolder resteasyServletHolder = new ServletHolder(HttpServletDispatcher.class);
        context.getInitParams().put("resteasy.servlet.mapping.prefix", "/");
        context.getInitParams().put("resteasy.document.expand.entity.references", "false");
        context.addServlet(resteasyServletHolder, "/*");
        ServletHolder registrationServletHolder = new ServletHolder(LicenseRegistrationServlet.class);
        registrationServletHolder.setInitParameter("productName", "XL TestView");
        registrationServletHolder.setInitParameter("productLogoUrl", "images/sprite-icons/xl-test-logo-color.svg");
        registrationServletHolder.setInitParameter("activationUrl", "https://xebialabs.com/products/xl-testview/trial/activation");
        context.addServlet(registrationServletHolder, "/productregistration/*");
        context.setHandler(this.accessLogHandler());
        context.setSessionHandler(this.sessionHandler());
        return context;
    }

    private SessionHandler sessionHandler() {
        HashSessionManager sessionManager = new HashSessionManager();
        HashSessionIdManager idManager = new HashSessionIdManager();
        sessionManager.getSessionCookieConfig().setName(this.config.getString("xlt.server.session-cookie-name"));
        sessionManager.getSessionCookieConfig().setHttpOnly(true);
        sessionManager.getSessionCookieConfig().setSecure(this.config.getBoolean("xlt.server.secure-cookie"));
        sessionManager.setSessionIdManager((SessionIdManager)idManager);
        return new SessionHandler((SessionManager)sessionManager);
    }

    private Handler accessLogHandler() {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        RequestLogImpl requestLogger = new RequestLogImpl();
        requestLogger.setQuiet(true);
        requestLogger.setResource("/logback-access.xml");
        requestLogHandler.setRequestLog((RequestLog)requestLogger);
        return requestLogHandler;
    }

    public static boolean isRunning() {
        return XlTestState.RUNNING.equals((Object)state);
    }

    public static boolean isUpgrading() {
        return XlTestState.UPGRADING.equals((Object)state);
    }
}

