/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.core.ListOfStringView;
import com.xebialabs.deployit.core.MapStringStringView;
import com.xebialabs.deployit.core.SetOfStringView;
import com.xebialabs.deployit.core.StringValue;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.io.DerivedArtifactFile;
import com.xebialabs.deployit.io.FileWithoutContent;
import com.xebialabs.deployit.io.SourceArtifactFile;
import com.xebialabs.deployit.jcr.JcrQueryTemplate;
import com.xebialabs.deployit.jcr.JcrUtils;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.NodeReaderContext;
import com.xebialabs.deployit.repository.NodeUtils;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.SearchQueryBuilder;
import com.xebialabs.deployit.repository.StringValueConverter;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.overthere.OverthereFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeReader {
    private Session session;
    private Node node;
    private final WorkDir workDir;
    private NodeReaderContext context;
    private final PasswordEncrypter passwordEncrypter;
    private static final Logger logger = LoggerFactory.getLogger(NodeReader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T extends ConfigurationItem> T read(Session session, Node node, int depth, WorkDir workDir, PasswordEncrypter passwordEncrypter) throws RepositoryException {
        NodeReaderContext c = NodeReaderContext.get().hold();
        try {
            T t = NodeReader.read(session, node, depth, workDir, c, passwordEncrypter);
            return t;
        }
        finally {
            c.release();
        }
    }

    static <T extends ConfigurationItem> T read(Session session, Node node, int depth, WorkDir workDir, NodeReaderContext context, PasswordEncrypter passwordEncrypter) throws RepositoryException {
        return new NodeReader(session, node, workDir, context, passwordEncrypter).read(depth);
    }

    private NodeReader(Session session, Node node, WorkDir workDir, NodeReaderContext context, PasswordEncrypter passwordEncrypter) {
        logger.trace("Creating NodeReader for node [{}] with workDir {} and context {}", new Object[]{node, workDir, context});
        this.session = session;
        this.node = node;
        this.workDir = workDir;
        this.context = context;
        this.passwordEncrypter = passwordEncrypter;
    }

    private <T extends ConfigurationItem> T read(int depth) throws RepositoryException {
        String id = JcrPathHelper.getIdFromAbsolutePath(this.node.getPath());
        logger.trace("Reading node [{}] with depth {} and workdir {}", new Object[]{id, depth, this.workDir});
        Object item = this.checkAlreadyRead();
        if (item != null) {
            return item;
        }
        Type type = Type.valueOf((String)this.node.getProperty("$configuration.item.type").getString());
        if (!type.exists()) {
            logger.warn("While trying to read node [{}] its type [{}] was not found in any plugin. Please make sure the required plugin is installed.", (Object)this.node.getPath(), (Object)type);
            throw new TypeNotFoundException(String.format("Unknown type [%s] while reading node [%s]", type, this.node.getPath()));
        }
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)type);
        item = descriptor.newInstance(id);
        if (depth > 0) {
            if (item instanceof BaseConfigurationItem) {
                ((BaseConfigurationItem)item).set$ciAttributes(NodeUtils.readCiAttributes(this.node));
                if (this.node.hasProperty("$token")) {
                    ((BaseConfigurationItem)item).set$token(this.node.getProperty("$token").getString());
                }
            }
            this.context.put(this.node.getIdentifier(), (ConfigurationItem)item);
            this.copyValues(item, depth - 1, descriptor);
            this.copyData(item, descriptor);
        }
        return item;
    }

    private <T extends ConfigurationItem> T checkAlreadyRead() throws RepositoryException {
        if (this.context.hasItem(this.node.getIdentifier())) {
            ConfigurationItem item = this.context.get(this.node.getIdentifier());
            Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)item.getType());
            if (descriptor.isAssignableTo(SourceArtifact.class) && this.workDir != null && ((SourceArtifact)item).getFile() instanceof FileWithoutContent) {
                this.copyData(item, descriptor);
            } else if (descriptor.isAssignableTo(DerivedArtifact.class) && this.workDir != null && ((DerivedArtifact)item).getFile() == null) {
                this.copyData(item, descriptor);
            }
            return (T)item;
        }
        return null;
    }

    private <T extends ConfigurationItem> void copyData(T item, Descriptor descriptor) throws RepositoryException {
        if (descriptor.isAssignableTo(SourceArtifact.class) && this.workDir != null) {
            logger.trace("Creating on-demand source artifact loader proxy for node [{}]", (Object)this.node.getPath());
            String filename = this.node.getProperty("$filename").getString();
            this.setProxyOnArtifact(item, filename);
        } else if (descriptor.isAssignableTo(SourceArtifact.class)) {
            logger.trace("Not loading artifact data from node [{}] because no workdir has been associated with this request", (Object)this.node.getPath());
            String filename = this.node.getProperty("$filename").getString();
            ((Artifact)item).setFile((OverthereFile)new FileWithoutContent(filename));
        } else if (descriptor.isAssignableTo(DerivedArtifact.class) && this.workDir != null) {
            logger.trace("Creating on-demand derived artifact loader for node [{}]", (Object)this.node.getPath());
            DerivedArtifact d = (DerivedArtifact)item;
            SourceArtifact sourceArtifact = d.getSourceArtifact();
            if (sourceArtifact != null) {
                d.setFile((OverthereFile)DerivedArtifactFile.create((DerivedArtifact)d));
                OverthereFile sourceFile = sourceArtifact.getFile();
                if (sourceFile instanceof FileWithoutContent) {
                    logger.trace("Source artifact [{}] was loaded without a work dir so creating an on-demand artifact loader proxy for it now", (Object)sourceArtifact.getId());
                    this.setProxyOnArtifact(sourceArtifact, sourceFile.getName());
                }
            }
        }
    }

    private <T extends ConfigurationItem> void setProxyOnArtifact(T item, String filename) {
        ((Artifact)item).setFile((OverthereFile)SourceArtifactFile.create((SourceArtifact)((SourceArtifact)item), (String)filename, (WorkDir)this.workDir));
    }

    private <T extends ConfigurationItem> void copyValues(T item, int depth, Descriptor descriptor) throws RepositoryException {
        block10: for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
            if (!NodeReader.hasProperty(this.node, pd) && !pd.isAsContainment()) {
                logger.trace("Repository node [{}] does not contain value for (non-containment) property [{}]. Using the default value.", (Object)item.getId(), (Object)pd);
                this.wrapDefaultValue(item, pd);
                continue;
            }
            if (pd.isTransient()) {
                if (NodeReader.hasProperty(this.node, pd)) {
                    logger.debug("Repository node [{}] contains transient property [{}] which should not have been persisted.", (Object)item.getId(), (Object)pd);
                }
                logger.trace("Not attempting to read transient property [{}] from repository node [{}]. Using the default value.", (Object)pd, (Object)item.getId());
                this.wrapDefaultValue(item, pd);
                continue;
            }
            switch (pd.getKind()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: {
                    this.setPrimitiveProperty(item, pd);
                    continue block10;
                }
                case DATE: {
                    pd.set(item, (Object)this.node.getProperty(pd.getName()).getDate().getTime());
                    continue block10;
                }
                case SET_OF_STRING: {
                    SetOfStringView setOfStringView = new SetOfStringView((Set)Sets.newHashSet(this.getCollectionOfStringValues(pd)));
                    if (pd.isPassword()) {
                        setOfStringView = setOfStringView.encrypt();
                    }
                    pd.set(item, (Object)setOfStringView);
                    continue block10;
                }
                case SET_OF_CI: {
                    pd.set(item, (Object)Sets.newHashSet(this.getCollectionOfConfigurationItemValues(item, depth, pd)));
                    continue block10;
                }
                case LIST_OF_STRING: {
                    ListOfStringView listOfStringView = new ListOfStringView((List)Lists.newArrayList(this.getCollectionOfStringValues(pd)));
                    if (pd.isPassword()) {
                        listOfStringView = listOfStringView.encrypt();
                    }
                    pd.set(item, (Object)listOfStringView);
                    continue block10;
                }
                case LIST_OF_CI: {
                    pd.set(item, (Object)Lists.newArrayList(this.getCollectionOfConfigurationItemValues(item, depth, pd)));
                    continue block10;
                }
                case CI: {
                    this.setConfigurationItemProperty(item, depth, pd);
                    continue block10;
                }
                case MAP_STRING_STRING: {
                    this.copyMapPropertyFromNode(item, pd);
                    continue block10;
                }
            }
            throw new IllegalStateException("Unsupported property kind: " + pd.getKind());
        }
    }

    private <T extends ConfigurationItem> void wrapDefaultValue(T item, PropertyDescriptor pd) {
        SetOfStringView newValue;
        Object value = pd.get(item);
        if (pd.getKind() == PropertyKind.SET_OF_STRING) {
            newValue = SetOfStringView.from((Set)((Set)value));
        } else if (pd.getKind() == PropertyKind.LIST_OF_STRING) {
            newValue = ListOfStringView.from((List)((List)value));
        } else if (pd.getKind() == PropertyKind.MAP_STRING_STRING) {
            newValue = MapStringStringView.from((Map)((Map)value));
        } else {
            return;
        }
        logger.trace("Wrapping default value [{}] in property [{}] of CI [{}]", new Object[]{value, pd.getFqn(), item.getId()});
        pd.set(item, (Object)newValue);
    }

    private static boolean hasProperty(Node node, PropertyDescriptor pd) throws RepositoryException {
        if (node.hasProperty(pd.getName())) {
            return true;
        }
        for (String s : pd.getAliases()) {
            if (!node.hasProperty(s)) continue;
            return true;
        }
        return false;
    }

    private static Property getProperty(Node node, PropertyDescriptor pd) throws RepositoryException {
        if (node.hasProperty(pd.getName())) {
            return node.getProperty(pd.getName());
        }
        for (String s : pd.getAliases()) {
            if (!node.hasProperty(s)) continue;
            return node.getProperty(s);
        }
        throw new IllegalStateException("Should have found a property on the node " + node.getPath() + " for propertydescriptor " + pd.getFqn());
    }

    private <T extends ConfigurationItem> void copyMapPropertyFromNode(T item, PropertyDescriptor pd) throws RepositoryException {
        Property property = NodeReader.getProperty(this.node, pd);
        Map<String, String> value = JcrUtils.readMap(property);
        MapStringStringView mapStringStringView = new MapStringStringView((Map)Maps.newHashMap((Map)Maps.transformValues(value, (Function)StringValueConverter.stringToValue((PasswordEncrypter)this.passwordEncrypter))));
        if (pd.isPassword()) {
            mapStringStringView = mapStringStringView.encrypt();
        }
        pd.set(item, (Object)mapStringStringView);
    }

    private <T extends ConfigurationItem> void setConfigurationItemProperty(T item, int depth, PropertyDescriptor pd) throws RepositoryException {
        Node referencedNode;
        if (pd.isAsContainment()) {
            if (this.node.isNodeType("{http://www.jcp.org/jcr/nt/1.0}frozenNode")) {
                logger.debug("Reading parent of frozen node [{}]", (Object)this.node.getPath());
                Node realNode = this.session.getNodeByIdentifier(this.node.getProperty("{http://www.jcp.org/jcr/1.0}frozenUuid").getString());
                referencedNode = realNode.getParent();
            } else {
                referencedNode = this.node.getParent();
            }
        } else {
            Value value = NodeReader.getProperty(this.node, pd).getValue();
            referencedNode = NodeUtils.getReferencedCiNode(this.node, value, this.session);
        }
        pd.set(item, (Object)this.readReference(referencedNode, depth));
    }

    private <T extends ConfigurationItem> Collection<ConfigurationItem> getCollectionOfConfigurationItemValues(T item, int depth, PropertyDescriptor pd) throws RepositoryException {
        ArrayList items = Lists.newArrayList();
        if (pd.isAsContainment() && pd.getKind() == PropertyKind.SET_OF_CI) {
            SearchParameters params = new SearchParameters().setParent(item.getId()).setType(pd.getReferencedType());
            Query query = ((JcrQueryTemplate)new SearchQueryBuilder(params).createTemplate()).createQuery(this.session);
            QueryResult queryResult = query.execute();
            NodeIterator iterator = queryResult.getNodes();
            while (iterator.hasNext()) {
                Node referencedNode = iterator.nextNode();
                items.add(this.readReference(referencedNode, depth));
            }
        } else {
            if (pd.isAsContainment() && pd.getKind() == PropertyKind.LIST_OF_CI && !NodeReader.hasProperty(this.node, pd)) {
                return items;
            }
            for (Value each : NodeReader.getProperty(this.node, pd).getValues()) {
                Node referencedNode = NodeUtils.getReferencedCiNode(this.node, each, this.session);
                items.add(this.readReference(referencedNode, depth));
            }
        }
        return items;
    }

    private ConfigurationItem readReference(Node referencedNode, int depth) throws RepositoryException {
        return NodeReader.read(this.session, referencedNode, depth, this.workDir, this.context, this.passwordEncrypter);
    }

    private Collection<StringValue> getCollectionOfStringValues(PropertyDescriptor pd) throws RepositoryException {
        StringValueConverter converter = new StringValueConverter(this.passwordEncrypter);
        ArrayList list = Lists.newArrayList();
        Property property = NodeReader.getProperty(this.node, pd);
        if (property.isMultiple()) {
            for (Value v : property.getValues()) {
                list.add(converter.convert(v.getString()));
            }
        } else {
            list.add(converter.convert(property.getString()));
        }
        return list;
    }

    private <T extends ConfigurationItem> void setPrimitiveProperty(T item, PropertyDescriptor pd) throws RepositoryException {
        String valueAsString = NodeReader.getProperty(this.node, pd).getString();
        if (pd.getKind() == PropertyKind.STRING && pd.isPassword()) {
            valueAsString = this.passwordEncrypter.ensureDecrypted(valueAsString);
        }
        pd.set(item, (Object)valueAsString);
    }

    @HttpResponseCodeResult(statusCode=500)
    public static class TypeNotFoundException
    extends DeployitException {
        public TypeNotFoundException(String message) {
            super(message);
        }
    }
}

