# NOTE: Please do not edit this file directly
# Create your custom reports in the 'ext' folder

import java.util.Date as Date

def has_result(events):
    result_event = [each for each in events if each.type == 'performanceResult']
    return len(result_event) > 0

run_times = []
completed_requests = []
failed_requests = []
mean_response_time = []
test_name = ''
test_specification = ''

runs = list(test_runs.getPreviousTestRuns(test_run, 9))
runs.append(test_run)

if runs:
    for run in runs:
        events = test_runs.getEventsForTestRun(run, {'@tags': tags} if tags else {})

        if has_result(events):
            for event in events:
                if event.type == 'importStarted':
                    if test_name == '':
                        test_name = event.get('simulationName')
                    run_times.append(Date(event.testedAt))
                if event.type == 'performanceResult':
                    completed_requests.append(event.get('numberOfRequests.ok'))
                    failed_requests.append(event.get('numberOfRequests.ko'))
                    mean_response_time.append(event.get('meanResponseTime.total'))

if test_name == '' or test_name is None:
    test_name = test_specification

titleText = 'Load Test Trends'

report_data_1 = {
    'chart': {
        'zoomType': 'xy'
    },
    'title': titleText,
    'description': 'This report shows the trend of the mean response time per request over multiple simulations and also shows the number of OK and not-OK responses in Bar Chart format',
    'xAxis': [{
                  'type': 'datetime',
                  'categories': run_times
              }],
    'yAxis': [{  # Secondary yAxis
                 'title': {
                     'text': 'Mean response time',
                     'style': {
                         'color': '#003300'
                     }
                 },
                 'labels': {
                     'format': '{value} ms',
                     'style': {
                         'color': '#003300'
                     }
                 },
                 'opposite': True
              },
        {  # Primary yAxis
                 'labels': {
                     'format': '{value}',
                     'style': {
                         'color': '#003300'
                     }
                 },
                 'title': {
                     'text': 'Number of Requests',
                     'style': {
                         'color': '#003300'
                     }
                 },
                 'stackLabels': {
                     'enabled': True,
                     'style': {
                         'fontWeight': 'bold',
                         'color': 'gray'
                     }
                 }
              }],
    'tooltip': {
        'shared': True
    },
    'plotOptions': {
        'column': {
            'animation': False,
            'stacking': 'normal',
            'dataLabels': {
                'enabled': True,
                'color': 'white',
                'style': {
                    'textShadow': '0 0 3px black, 0 0 3px black'
                }
            }
        }
    },
    'legend': {
        'layout': 'vertical',
        'align': 'left',
        'x': 120,
        'verticalAlign': 'top',
        'y': 0,
        'floating': True,
        'backgroundColor': '#FFFFFF'
    },
    'series': [{
                   'name': 'completed requests',
                   'type': 'column',
                   'yAxis': 1,
                   'data': completed_requests

               },
               {
                   'name': 'failed requests',
                   'type': 'column',
                   'yAxis': 1,
                   'data': failed_requests

               },
               {
                   'name': 'mean response time',
                   'type': 'spline',
                   'data': mean_response_time,
                   'animation': False,
                   'tooltip': {
                       'valueSuffix': 'ms'
                   }
               }]
}

result_holder.result = report_data_1
