# NOTE: Please do not edit this file directly
# Create your custom qualifications in the 'ext' folder

olderTestRuns = test_runs.getPreviousTestRuns(test_run, 5)

logger.debug("testrun {}: previous runs: {}", test_run.id, olderTestRuns)

# now get the result event from each of the testruns
all_responsetimes = []

for t in olderTestRuns:
    eventsInRun = test_runs.getEventsForTestRun(t, {})
    for ev in eventsInRun:
        if ev.type == 'performanceResult':
            all_responsetimes.append(float(ev.get('meanResponseTime.total')))

avg_responsetime = 0
if len(all_responsetimes) > 0:
    avg_responsetime = sum(all_responsetimes) / len(all_responsetimes)
else:
    logger.debug("testrun {}: no history yet, assuming average response time is infinity", test_run.id, olderTestRuns)
    avg_responsetime = float('inf')

percentage_ko = 0.0
last_responsetime = 0
total_results = 0

for ev in events:
    if ev.type == 'performanceResult':
        last_responsetime = float(ev.get('meanResponseTime.total'))
        total_results = int(ev.get('numberOfRequests.total'))
        total_ko = int(ev.get('numberOfRequests.ko'))

if total_results == 0:
    result = {"success": False, "reason": "No test results"}
    logger.info("testrun {}: success=true, no results", test_run.id)
elif float(total_ko / total_results) > 0.1:
    result = {"success": False, "reason": "{:.0%} of tests failed, which is more than 10%".format(float(total_ko / total_results))}
    logger.info("testrun {}: success=false, more than 10% of the tests ko'ed", test_run.id)
else:
    success = last_responsetime < avg_responsetime * 1.1
    reason =  "Last response time = {:.0f} ms. Average response time = {:.0f} ms. Response time should be lower than average + 10%.".format(last_responsetime, avg_responsetime)
    logger.info("testrun {}: success=true, reason={}", test_run.id, reason)
    result = {"success": success, "reason": reason, "response_time": last_responsetime}

result_holder.result = result
