#
# Basic execution of test cases on a host
#
from com.xebialabs.overthere.util import CapturingOverthereExecutionOutputHandler
from com.xebialabs.xlt.plugin.api.testrun import Event
import java.util.Date as Date

host = self.host

if host.hasProperty('jobParameters'):
    job_parameters = dict(parameters)
    job_parameters['XL_TEST_RUN_ID'] = test_run_id
    host.setProperty('jobParameters', job_parameters)

connection = host.getConnection()
exit_code = -1
import_start_date = Date()
event_parameters = dict(parameters)
event_parameters['commandLine'] = resolved_command_line
event_parameters[Event.RUN_ID] = test_run_id
event_handler.onReceive(Event(Event.EXECUTION_STARTED, event_parameters))
try:
    print "Performing:", str(self.cmdLine), "on host", str(host)
    stdout_handler = CapturingOverthereExecutionOutputHandler.capturingHandler()
    stderr_handler = CapturingOverthereExecutionOutputHandler.capturingHandler()
    working_directory = self.getWorkingDirectory()
    if working_directory:
        connection.setWorkingDirectory(connection.getFile(working_directory))
        print 'Set up the handlers, now executing in working directory %s...' % working_directory
    else:
        print "Set up the handlers, now executing in default working directory..."
    exit_code = connection.execute(stdout_handler, stderr_handler, self.getCmdLine(resolved_command_line))

    for line in stdout_handler.getOutputLines():
        print "output:", line
    for line in stderr_handler.getOutputLines():
        print "error:", line

    print "All done, no exceptions"
finally:
    connection.close()
    # TODO: add "failureReason" property when needed.
    finished_parameters = dict(event_parameters)
    finished_parameters['exitCode'] = exit_code
    event_handler.onReceive(Event(Event.EXECUTION_FINISHED, finished_parameters))
