/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.ParameterRole;
import freemarker.core.TemplateElement;
import freemarker.core._CoreStringUtils;
import freemarker.template.TemplateException;
import java.io.IOException;

class EscapeBlock
extends TemplateElement {
    private final String variable;
    private final Expression expr;
    private Expression escapedExpr;

    EscapeBlock(String variable, Expression expr, Expression escapedExpr) {
        this.variable = variable;
        this.expr = expr;
        this.escapedExpr = escapedExpr;
    }

    void setContent(TemplateElement nestedBlock) {
        this.nestedBlock = nestedBlock;
        this.escapedExpr = null;
    }

    void accept(Environment env) throws TemplateException, IOException {
        if (this.nestedBlock != null) {
            env.visit(this.nestedBlock);
        }
    }

    Expression doEscape(Expression expression) {
        return this.escapedExpr.deepCloneWithIdentifierReplaced(this.variable, expression, new Expression.ReplacemenetState());
    }

    protected String dump(boolean canonical) {
        StringBuffer sb = new StringBuffer();
        if (canonical) {
            sb.append('<');
        }
        sb.append(this.getNodeTypeSymbol()).append(' ').append(_CoreStringUtils.toFTLTopLevelIdentifierReference(this.variable)).append(" as ").append(this.expr.getCanonicalForm());
        if (canonical) {
            sb.append('>').append(this.nestedBlock.getCanonicalForm()).append("</").append(this.getNodeTypeSymbol()).append('>');
        }
        return sb.toString();
    }

    String getNodeTypeSymbol() {
        return "#escape";
    }

    boolean isShownInStackTrace() {
        return false;
    }

    int getParameterCount() {
        return 2;
    }

    Object getParameterValue(int idx) {
        switch (idx) {
            case 0: {
                return this.variable;
            }
            case 1: {
                return this.expr;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        switch (idx) {
            case 0: {
                return ParameterRole.PLACEHOLDER_VARIABLE;
            }
            case 1: {
                return ParameterRole.EXPRESSION_TEMPLATE;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    boolean isOutputCacheable() {
        return true;
    }

    boolean isNestedBlockRepeater() {
        return false;
    }
}

