/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.basic;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.GraphI18n;
import org.modeshape.jcr.value.NamespaceRegistry;

public class NamespaceRegistryWithAliases
implements NamespaceRegistry {
    private final NamespaceRegistry delegate;
    private final Map<String, String> aliaseNamespaceUriByPrefix;
    private final Map<String, String> namespaceUrisByAlias;

    public NamespaceRegistryWithAliases(NamespaceRegistry delegate, Map<String, String> aliaseNamespaceUriByPrefix, Map<String, String> namespaceUrisByAliasUri) {
        CheckArg.isNotNull((Object)delegate, (String)"delegate");
        CheckArg.isNotEmpty(aliaseNamespaceUriByPrefix, (String)"aliases");
        CheckArg.isNotEmpty(namespaceUrisByAliasUri, (String)"namespaceUrisByAlias");
        this.delegate = delegate;
        this.aliaseNamespaceUriByPrefix = aliaseNamespaceUriByPrefix;
        this.namespaceUrisByAlias = Collections.unmodifiableMap(new HashMap<String, String>(namespaceUrisByAliasUri));
        HashMap<String, String> copyOfNamespaceUrisByAlias = new HashMap<String, String>(this.namespaceUrisByAlias);
        for (String aliasedNamespaceUri : this.aliaseNamespaceUriByPrefix.values()) {
            if (copyOfNamespaceUrisByAlias.remove(aliasedNamespaceUri) != null) continue;
            I18n msg = GraphI18n.namespaceAliasWasNotMappedToRealNamespace;
            throw new IllegalArgumentException(msg.text(new Object[]{aliasedNamespaceUri}));
        }
        if (!copyOfNamespaceUrisByAlias.isEmpty()) {
            I18n msg = GraphI18n.aliasesMappedToRealNamespacesButWereNotRegisteredInAliasNamespace;
            throw new IllegalArgumentException(msg.text(new Object[]{copyOfNamespaceUrisByAlias}));
        }
    }

    @Override
    public String getDefaultNamespaceUri() {
        return this.delegate.getDefaultNamespaceUri();
    }

    @Override
    public String getNamespaceForPrefix(String prefix) {
        String uri = this.delegate.getNamespaceForPrefix(prefix);
        if (uri == null) {
            uri = this.aliaseNamespaceUriByPrefix.get(prefix);
            if (uri != null) {
                String originalUri = this.namespaceUrisByAlias.get(uri);
                assert (originalUri != null);
                uri = originalUri;
            }
        } else {
            String originalUri = this.namespaceUrisByAlias.get(uri);
            if (originalUri != null) {
                uri = originalUri;
            }
        }
        return uri;
    }

    @Override
    public Set<NamespaceRegistry.Namespace> getNamespaces() {
        return this.delegate.getNamespaces();
    }

    @Override
    public String getPrefixForNamespaceUri(String namespaceUri, boolean generateIfMissing) {
        String originalNamespaceUri = this.namespaceUrisByAlias.get(namespaceUri);
        if (originalNamespaceUri != null) {
            namespaceUri = originalNamespaceUri;
        }
        return this.delegate.getPrefixForNamespaceUri(namespaceUri, generateIfMissing);
    }

    @Override
    public Set<String> getRegisteredNamespaceUris() {
        return this.delegate.getRegisteredNamespaceUris();
    }

    @Override
    public boolean isRegisteredNamespaceUri(String namespaceUri) {
        return this.delegate.isRegisteredNamespaceUri(namespaceUri);
    }

    @Override
    public void register(Iterable<NamespaceRegistry.Namespace> namespaces) {
        this.delegate.register(namespaces);
    }

    @Override
    public String register(String prefix, String namespaceUri) {
        return this.delegate.register(prefix, namespaceUri);
    }

    @Override
    public boolean unregister(String namespaceUri) {
        return this.delegate.unregister(namespaceUri);
    }
}

