/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.mimetype;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import org.apache.tika.detect.CompositeDetector;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.MimeTypesFactory;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.SelfClosingInputStream;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.mimetype.MimeTypeDetector;

@Immutable
@ThreadSafe
public final class TikaMimeTypeDetector
implements MimeTypeDetector {
    private static final Logger LOGGER = Logger.getLogger(TikaMimeTypeDetector.class);
    protected final MimeTypes mimetypes;
    private final CompositeDetector allDetectors;
    private final Detector nameOnlyDetector;

    public TikaMimeTypeDetector(ClassLoader classLoader) {
        ArrayList<URL> validUrls = new ArrayList<URL>(3);
        validUrls.add(classLoader.getResource("org/apache/tika/mime/tika-mimetypes.xml"));
        validUrls.add(classLoader.getResource("org/apache/tika/mime/custom-tika-mimetypes.xml"));
        validUrls.add(classLoader.getResource("org/modeshape/custom-mimetypes.xml"));
        Iterator iter = validUrls.iterator();
        while (iter.hasNext()) {
            URL url = (URL)iter.next();
            if (url == null) {
                iter.remove();
                continue;
            }
            try {
                MimeTypesFactory.create((URL)url);
            }
            catch (Exception e) {
                LOGGER.warn((Throwable)e, (I18nResource)JcrI18n.unableToReadMediaTypeRegistry, new Object[]{url, e.getMessage()});
                iter.remove();
            }
        }
        URL[] urls = validUrls.toArray(new URL[validUrls.size()]);
        try {
            this.mimetypes = MimeTypesFactory.create((URL[])urls);
        }
        catch (Exception e) {
            throw new SystemFailureException(JcrI18n.unableToInitializeMimeTypeDetector.text(new Object[]{urls, e.getMessage()}), (Throwable)e);
        }
        this.allDetectors = new DefaultDetector(this.mimetypes, classLoader);
        this.nameOnlyDetector = this.mimetypes;
        LOGGER.debug("Initializing the Tika MIME type detectors", new Object[0]);
        for (Detector detector : this.allDetectors.getDetectors()) {
            LOGGER.debug(" - Found detector: " + detector.getClass().getName(), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String mimeTypeOf(String name, Binary binaryValue) throws RepositoryException, IOException {
        Metadata metadata = new Metadata();
        if (!StringUtil.isBlank((String)name)) {
            metadata.set("resourceName", name);
        }
        MediaType autoDetectedMimeType = null;
        if (binaryValue == null) {
            if (name == null) {
                return null;
            }
            try {
                autoDetectedMimeType = this.nameOnlyDetector.detect(null, metadata);
            }
            catch (IOException e) {
                LOGGER.debug((Throwable)e, "Unable to extract mime-type", new Object[0]);
            }
        } else {
            InputStream stream = binaryValue.getStream();
            if (stream instanceof SelfClosingInputStream) {
                stream = ((SelfClosingInputStream)stream).wrappedStream();
            }
            TemporaryResources tmp = new TemporaryResources();
            try {
                TikaInputStream tikaInputStream = TikaInputStream.get((InputStream)stream, (TemporaryResources)tmp);
                autoDetectedMimeType = this.allDetectors.detect((InputStream)tikaInputStream, metadata);
            }
            catch (Exception e) {
                LOGGER.debug((Throwable)e, "Unable to extract mime-type", new Object[0]);
            }
            finally {
                try {
                    tmp.close();
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
        }
        return autoDetectedMimeType != null ? autoDetectedMimeType.toString() : null;
    }
}

