/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.Iterator;
import java.util.Set;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.document.AbstractChildReferences;
import org.modeshape.jcr.cache.document.ImmutableChildReferences;
import org.modeshape.jcr.cache.document.MutableChildReferences;
import org.modeshape.jcr.cache.document.SessionNode;
import org.modeshape.jcr.cache.document.UnionIterator;
import org.modeshape.jcr.value.Name;

@ThreadSafe
public class SessionChildReferences
extends AbstractChildReferences {
    private final ChildReferences persisted;
    private final MutableChildReferences appended;
    private final SessionNode.ChangedChildren changedChildren;
    private final boolean allowsSNS;

    public SessionChildReferences(ChildReferences persisted, MutableChildReferences appended, SessionNode.ChangedChildren changedChildren, boolean allowsSNS) {
        this.persisted = persisted != null ? persisted : ImmutableChildReferences.EMPTY_CHILD_REFERENCES;
        this.appended = appended;
        this.changedChildren = changedChildren;
        this.allowsSNS = allowsSNS;
    }

    @Override
    public long size() {
        return this.persisted.size() + (this.appended != null ? this.appended.size() : 0L);
    }

    @Override
    public int getChildCount(Name name) {
        int appendedChildren = this.appended != null ? this.appended.getChildCount(name) : 0;
        int persistedChildrenCount = 0;
        int removedChildren = 0;
        int renamedChildren = 0;
        int appendedThenReorderedChildren = 0;
        Iterator<ChildReference> childReferenceIterator = this.persisted.iterator(name);
        while (childReferenceIterator.hasNext()) {
            ChildReference persistedChild = childReferenceIterator.next();
            ++persistedChildrenCount;
            if (this.changedChildren == null) continue;
            if (this.changedChildren.isRemoved(persistedChild)) {
                --removedChildren;
                continue;
            }
            if (!this.changedChildren.isRenamed(persistedChild)) continue;
            --renamedChildren;
        }
        if (this.changedChildren != null) {
            appendedThenReorderedChildren = this.changedChildren.insertionCount(name);
            if (this.changedChildren.isRenamed(name)) {
                ++renamedChildren;
            }
        }
        return persistedChildrenCount + appendedChildren + appendedThenReorderedChildren + removedChildren + renamedChildren;
    }

    @Override
    public ChildReference getChild(Name name, int snsIndex, ChildReferences.Context context) {
        ChildReference ref;
        if (!this.allowsSNS && snsIndex > 1) {
            return null;
        }
        if (this.changedChildren != null && !this.changedChildren.isEmpty()) {
            context = new ChildReferences.WithChanges(context, this.changedChildren);
        }
        if ((ref = this.persisted.getChild(name, snsIndex, context)) == null && this.appended != null && (ref = this.appended.getChild(name, snsIndex, context)) == null && this.changedChildren != null && this.changedChildren.insertionCount() > 0) {
            Iterator<ChildReferences.ChildInsertions> insertionsWithName = this.changedChildren.insertions(name);
            while (insertionsWithName.hasNext()) {
                for (ChildReference inserted : insertionsWithName.next().inserted()) {
                    if (inserted.getSnsIndex() != snsIndex) continue;
                    return inserted;
                }
            }
        }
        return ref;
    }

    @Override
    public boolean hasChild(NodeKey key) {
        return this.persisted.hasChild(key) || this.appended != null && this.appended.hasChild(key) || this.changedChildren != null && this.changedChildren.inserted(key) != null;
    }

    @Override
    public ChildReference getChild(NodeKey key) {
        return this.getChild(key, this.defaultContext());
    }

    @Override
    public ChildReference getChild(NodeKey key, ChildReferences.Context context) {
        ChildReference ref;
        if (this.changedChildren != null && !this.changedChildren.isEmpty()) {
            context = new ChildReferences.WithChanges(context, this.changedChildren);
        }
        if ((ref = this.persisted.getChild(key, context)) == null && this.appended != null) {
            ref = this.appended.getChild(key, context);
            if (ref != null) {
                int numSnsInPersisted = this.persisted.getChildCount(ref.getName());
                if (numSnsInPersisted != 0) {
                    int numSnsInRemoved = 0;
                    if (this.changedChildren != null && !this.changedChildren.isEmpty()) {
                        Set<NodeKey> removals = this.changedChildren.getRemovals();
                        if (removals.contains(key)) {
                            numSnsInRemoved = 1;
                        }
                        for (int i = 1; i <= numSnsInPersisted; ++i) {
                            NodeKey persistedChildKey = this.persisted.getChild(ref.getName(), i).getKey();
                            if (key.equals(persistedChildKey) || !removals.contains(persistedChildKey)) continue;
                            ++numSnsInRemoved;
                        }
                    }
                    ref = ref.with(numSnsInPersisted + ref.getSnsIndex() - numSnsInRemoved);
                }
            } else if (this.changedChildren != null && this.changedChildren.insertionCount() > 0) {
                ref = this.changedChildren.inserted(key);
            }
        }
        return ref;
    }

    @Override
    public Iterator<ChildReference> iterator(Name name, ChildReferences.Context context) {
        if (this.changedChildren != null && !this.changedChildren.isEmpty()) {
            context = new ChildReferences.WithChanges(context, this.changedChildren);
        }
        return this.createIterator(name, context);
    }

    protected Iterator<ChildReference> createIterator(final Name name, final ChildReferences.Context context) {
        UnionIterator<ChildReference> firstIter = this.persisted.iterator(name, context);
        final MutableChildReferences appended = this.appended;
        Iterable<ChildReference> second = new Iterable<ChildReference>(){

            @Override
            public Iterator<ChildReference> iterator() {
                return appended.iterator(context, name);
            }
        };
        return appended == null ? firstIter : new UnionIterator<ChildReference>(firstIter, second);
    }

    @Override
    public Iterator<ChildReference> iterator(ChildReferences.Context context) {
        if (this.changedChildren != null && !this.changedChildren.isEmpty()) {
            context = new ChildReferences.WithChanges(context, this.changedChildren);
        }
        return this.createIterator(context);
    }

    protected Iterator<ChildReference> createIterator(final ChildReferences.Context context) {
        UnionIterator<ChildReference> firstIter = this.persisted.iterator(context);
        final MutableChildReferences appended = this.appended;
        Iterable<ChildReference> second = new Iterable<ChildReference>(){

            @Override
            public Iterator<ChildReference> iterator() {
                return appended.iterator(context);
            }
        };
        return appended == null ? firstIter : new UnionIterator<ChildReference>(firstIter, second);
    }

    @Override
    public Iterator<NodeKey> getAllKeys() {
        UnionIterator<NodeKey> firstIter = this.persisted.getAllKeys();
        final MutableChildReferences appended = this.appended;
        Iterable<NodeKey> second = new Iterable<NodeKey>(){

            @Override
            public Iterator<NodeKey> iterator() {
                return appended.getAllKeys();
            }
        };
        return appended == null ? firstIter : new UnionIterator<NodeKey>(firstIter, second);
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        Iterator<ChildReference> iter = this.iterator();
        if (iter.hasNext()) {
            sb.append(iter.next());
            while (iter.hasNext()) {
                sb.append(", ");
                sb.append(iter.next());
            }
        }
        return sb;
    }

    @Override
    public boolean allowsSNS() {
        return this.allowsSNS;
    }
}

