/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Calendar;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.version.Version;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrProperty;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrSystemNode;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.JcrVersionHistoryNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.basic.NodeKeyReference;

class JcrVersionNode
extends JcrSystemNode
implements Version {
    private static final Version[] EMPTY_VERSION_ARRAY = new Version[0];

    JcrVersionNode(JcrSession session, NodeKey key) {
        super(session, key);
    }

    @Override
    AbstractJcrNode.Type type() {
        return AbstractJcrNode.Type.VERSION;
    }

    @Override
    public JcrVersionHistoryNode getParent() throws ItemNotFoundException, RepositoryException {
        return (JcrVersionHistoryNode)super.getParent();
    }

    public JcrVersionHistoryNode getContainingHistory() throws RepositoryException {
        return this.getParent();
    }

    public Calendar getCreated() throws RepositoryException {
        return this.getProperty(JcrLexicon.CREATED).getDate();
    }

    public AbstractJcrNode getFrozenNode() throws RepositoryException {
        return this.childNode(JcrLexicon.FROZEN_NODE, AbstractJcrNode.Type.SYSTEM);
    }

    public Version[] getPredecessors() throws RepositoryException {
        return this.getNodesForProperty(JcrLexicon.PREDECESSORS);
    }

    public Version[] getSuccessors() throws RepositoryException {
        return this.getNodesForProperty(JcrLexicon.SUCCESSORS);
    }

    private final Version[] getNodesForProperty(Name propertyName) throws RepositoryException {
        assert (JcrLexicon.SUCCESSORS.equals(propertyName) || JcrLexicon.PREDECESSORS.equals(propertyName));
        AbstractJcrProperty references = this.getProperty(propertyName);
        if (references == null) {
            return EMPTY_VERSION_ARRAY;
        }
        Value[] values = references.getValues();
        ArrayList<JcrVersionNode> versions = new ArrayList<JcrVersionNode>(values.length);
        for (Value value : values) {
            NodeKey key = ((NodeKeyReference)((JcrValue)value).value()).getNodeKey();
            AbstractJcrNode node = this.session().node(key, null);
            versions.add((JcrVersionNode)node);
        }
        return versions.toArray(EMPTY_VERSION_ARRAY);
    }

    private final JcrVersionNode getFirstNodeForProperty(Name propertyName) throws RepositoryException {
        assert (JcrLexicon.SUCCESSORS.equals(propertyName) || JcrLexicon.PREDECESSORS.equals(propertyName));
        AbstractJcrProperty references = this.getProperty(propertyName);
        if (references == null) {
            return null;
        }
        Value[] values = references.getValues();
        if (values.length == 0) {
            return null;
        }
        NodeKey key = ((NodeKeyReference)((JcrValue)values[0]).value()).getNodeKey();
        AbstractJcrNode node = this.session().node(key, null);
        return (JcrVersionNode)node;
    }

    boolean isLinearSuccessorOf(JcrVersionNode other) throws RepositoryException {
        if (!other.hasProperty(JcrLexicon.SUCCESSORS)) {
            return false;
        }
        JcrValue[] successors = other.getProperty(JcrLexicon.SUCCESSORS).getValues();
        String id = this.getIdentifier();
        for (int i = 0; i < successors.length; ++i) {
            if (!id.equals(successors[i].getString())) continue;
            return true;
        }
        return false;
    }

    boolean isEventualSuccessorOf(JcrVersionNode other) throws RepositoryException {
        if (this.isLinearSuccessorOf(other)) {
            return true;
        }
        for (Version successor : other.getSuccessors()) {
            if (!this.isEventualSuccessorOf((JcrVersionNode)successor)) continue;
            return true;
        }
        return false;
    }

    public JcrVersionNode getLinearPredecessor() throws RepositoryException {
        return this.getFirstNodeForProperty(JcrLexicon.PREDECESSORS);
    }

    public JcrVersionNode getLinearSuccessor() throws RepositoryException {
        return this.getFirstNodeForProperty(JcrLexicon.SUCCESSORS);
    }
}

