/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import javax.jcr.version.VersionException;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.MutableCachedNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.security.SecurityContext;
import org.modeshape.jcr.security.SimplePrincipal;
import org.modeshape.jcr.security.acl.AccessControlPolicyIteratorImpl;
import org.modeshape.jcr.security.acl.JcrAccessControlList;
import org.modeshape.jcr.security.acl.PrivilegeImpl;
import org.modeshape.jcr.security.acl.Privileges;
import org.modeshape.jcr.value.Path;

public class AccessControlManagerImpl
implements AccessControlManager {
    private static final AccessControlPolicy[] EMPTY_POLICIES = new AccessControlPolicy[0];
    private final JcrSession session;
    private final Privileges privileges;
    private final JcrAccessControlList defaultACL;

    protected AccessControlManagerImpl(JcrSession session) {
        this.session = session;
        this.privileges = new Privileges(session);
        this.defaultACL = JcrAccessControlList.defaultAcl(this);
    }

    public Privilege[] privileges() {
        return this.privileges.listOfSupported();
    }

    public Privilege[] getSupportedPrivileges(String path) {
        return this.privileges.listOfSupported();
    }

    public Privilege privilegeFromName(String name) throws AccessControlException, RepositoryException {
        PrivilegeImpl p = this.privileges.forName(name);
        if (p == null) {
            throw new AccessControlException(name + " is not a valid name for privilege");
        }
        return p;
    }

    public boolean hasPrivileges(String path, Privilege[] privileges) throws PathNotFoundException, RepositoryException {
        JcrAccessControlList acl = this.getApplicableACL(path);
        return acl.isEmpty() || acl.hasPrivileges(this.securityContext(), privileges);
    }

    private JcrAccessControlList getApplicableACL(String path) throws RepositoryException {
        JcrAccessControlList acl = this.findAccessList(path, true);
        return acl != null ? acl : this.defaultACL;
    }

    public Privilege[] getPrivileges(String path) throws PathNotFoundException, RepositoryException {
        JcrAccessControlList acl = this.getApplicableACL(path);
        return acl.getPrivileges(this.securityContext());
    }

    public AccessControlPolicy[] getPolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        AccessControlPolicy[] accessControlPolicyArray;
        if (this.session.isReadOnly()) {
            throw new AccessDeniedException(JcrI18n.permissionDenied.text(new Object[]{absPath, "read access control content"}));
        }
        if (!this.hasPrivileges(absPath, new Privilege[]{this.privileges.forName("{http://www.jcp.org/jcr/1.0}readAccessControl")})) {
            throw new AccessDeniedException(JcrI18n.permissionDenied.text(new Object[]{absPath, "read access control content"}));
        }
        JcrAccessControlList acl = this.findAccessList(absPath, false);
        if (acl == null) {
            accessControlPolicyArray = EMPTY_POLICIES;
        } else {
            AccessControlPolicy[] accessControlPolicyArray2 = new AccessControlPolicy[1];
            accessControlPolicyArray = accessControlPolicyArray2;
            accessControlPolicyArray2[0] = acl;
        }
        return accessControlPolicyArray;
    }

    private SecurityContext securityContext() {
        return this.session.context().getSecurityContext();
    }

    public AccessControlPolicy[] getEffectivePolicies(String path) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        AccessControlPolicy[] policies = this.getPolicies(path);
        if (policies.length == 0) {
            return new AccessControlPolicy[]{(AccessControlPolicy)this.getApplicablePolicies(path).next()};
        }
        return policies;
    }

    public AccessControlPolicyIterator getApplicablePolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        if (this.session.isReadOnly()) {
            throw new AccessDeniedException(JcrI18n.permissionDenied.text(new Object[]{absPath, "read access control content"}));
        }
        JcrAccessControlList acl = this.getApplicableACL(absPath);
        if (!acl.isEmpty() && !acl.hasPrivileges(this.securityContext(), new Privilege[]{this.privileges.forName("{http://www.jcp.org/jcr/1.0}readAccessControl")})) {
            throw new AccessDeniedException();
        }
        CachedNode node = this.session.cachedNode((Path)this.session.pathFactory().create(absPath), false);
        if (node.hasACL(this.session.cache())) {
            return AccessControlPolicyIteratorImpl.EMPTY;
        }
        return new AccessControlPolicyIteratorImpl(new AccessControlPolicy[]{new JcrAccessControlList(absPath)});
    }

    public void setPolicy(String absPath, AccessControlPolicy policy) throws PathNotFoundException, AccessControlException, AccessDeniedException, LockException, VersionException, RepositoryException {
        if (this.session.isReadOnly()) {
            throw new AccessDeniedException(JcrI18n.permissionDenied.text(new Object[]{absPath, "read access control content"}));
        }
        if (!this.hasPrivileges(absPath, new Privilege[]{this.privileges.forName("{http://www.jcp.org/jcr/1.0}modifyAccessControl")})) {
            throw new AccessDeniedException(JcrI18n.permissionDenied.text(new Object[]{absPath, "modify access control content"}));
        }
        if (!(policy instanceof JcrAccessControlList)) {
            throw new AccessControlException("Invalid policy class (expected JcrAccessControlList): " + policy.getClass().getSimpleName());
        }
        JcrAccessControlList acl = (JcrAccessControlList)policy;
        Map<String, Set<String>> privilegesByPrincipalName = this.privilegesByPrincipalName(acl);
        try {
            CachedNode cacheNode = this.session.cachedNode((Path)this.session.pathFactory().create(absPath), false);
            SessionCache cache = this.session.cache();
            MutableCachedNode mutableNode = cache.mutable(cacheNode.getKey());
            MutableCachedNode.PermissionChanges permissionChanges = mutableNode.setPermissions(cache, privilegesByPrincipalName);
            this.session.aclAdded(permissionChanges.addedPrincipalsCount());
            this.session.aclRemoved(permissionChanges.removedPrincipalsCount());
        }
        catch (UnsupportedOperationException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void removePolicy(String absPath, AccessControlPolicy policy) throws PathNotFoundException, AccessControlException, AccessDeniedException, LockException, VersionException, RepositoryException {
        if (this.session.isReadOnly()) {
            throw new AccessDeniedException(JcrI18n.permissionDenied.text(new Object[]{absPath, "read access control content"}));
        }
        if (!this.hasPrivileges(absPath, new Privilege[]{this.privileges.forName("{http://www.jcp.org/jcr/1.0}modifyAccessControl")})) {
            throw new AccessDeniedException(JcrI18n.permissionDenied.text(new Object[]{absPath, "modify access control content"}));
        }
        try {
            CachedNode cacheNode = this.session.cachedNode((Path)this.session.pathFactory().create(absPath), false);
            SessionCache cache = this.session.cache();
            MutableCachedNode mutableNode = cache.mutable(cacheNode.getKey());
            MutableCachedNode.PermissionChanges permissionChanges = mutableNode.removeACL(cache);
            this.session.aclRemoved(permissionChanges.removedPrincipalsCount());
        }
        catch (UnsupportedOperationException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private Map<String, Set<String>> privilegesByPrincipalName(JcrAccessControlList acl) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (AccessControlEntry ace : acl.getAccessControlEntries()) {
            assert (ace.getPrincipal() != null);
            String name = ace.getPrincipal().getName();
            HashSet<String> privileges = new HashSet<String>();
            for (Privilege privilege : ace.getPrivileges()) {
                privileges.add(privilege.getName());
            }
            result.put(name, privileges);
        }
        return result;
    }

    private JcrAccessControlList findAccessList(String absPath, boolean searchParents) throws PathNotFoundException, RepositoryException {
        CachedNode startingNode = this.session.cachedNode((Path)this.session.pathFactory().create(absPath), false);
        SessionCache sessionCache = this.session.cache();
        Map<String, Set<String>> permissions = startingNode.getPermissions(sessionCache);
        CachedNode node = startingNode;
        if (searchParents) {
            NodeKey parentKey;
            while ((permissions == null || permissions.isEmpty()) && (parentKey = node.getParentKey(sessionCache)) != null && (node = sessionCache.getNode(parentKey)) != null) {
                permissions = node.getPermissions(sessionCache);
            }
        }
        if (permissions == null || node == null) {
            return null;
        }
        String aclPath = startingNode.getKey().equals(node.getKey()) ? absPath : node.getPath(sessionCache).getString();
        JcrAccessControlList acl = new JcrAccessControlList(aclPath);
        for (String principalName : permissions.keySet()) {
            Set<String> privileges = permissions.get(principalName);
            acl.addAccessControlEntry(this.principal(principalName), this.privileges(privileges));
        }
        return acl;
    }

    private Privilege[] privileges(Set<String> names) throws ValueFormatException, AccessControlException, RepositoryException {
        Privilege[] privileges = new Privilege[names.size()];
        int i = 0;
        for (String name : names) {
            privileges[i++] = this.privilegeFromName(name);
        }
        return privileges;
    }

    protected boolean hasPermission(Path absPath, String ... actions) {
        Privilege[] permissions = new Privilege[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            permissions[i] = this.privileges.forAction(actions[i]);
        }
        try {
            return this.hasPrivileges(absPath.toString(), permissions);
        }
        catch (Exception e) {
            return true;
        }
    }

    private Principal principal(String name) {
        return SimplePrincipal.newInstance(name);
    }
}

