/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testrunner;

import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PageListSetUpTearDownSurrounder {
    private final WikiPage root;

    public PageListSetUpTearDownSurrounder(WikiPage root) {
        this.root = root;
    }

    public List<WikiPage> surroundGroupsOfTestPagesWithRespectiveSetUpAndTearDowns(List<WikiPage> pageList) {
        Map<String, LinkedList<WikiPage>> pageSetUpTearDownGroups = this.createPageSetUpTearDownGroups(pageList);
        return this.reinsertPagesViaSetUpTearDownGroups(pageSetUpTearDownGroups);
    }

    private Map<String, LinkedList<WikiPage>> createPageSetUpTearDownGroups(List<WikiPage> pageList) {
        HashMap<String, LinkedList<WikiPage>> pageSetUpTearDownGroups = new HashMap<String, LinkedList<WikiPage>>();
        for (WikiPage page : pageList) {
            this.makeSetUpTearDownPageGroupForPage(page, pageSetUpTearDownGroups);
        }
        return pageSetUpTearDownGroups;
    }

    private void makeSetUpTearDownPageGroupForPage(WikiPage page, Map<String, LinkedList<WikiPage>> pageSetUpTearDownGroups) {
        String group = this.getSetUpTearDownGroup(page);
        if (pageSetUpTearDownGroups.get(group) != null) {
            LinkedList<WikiPage> pageGroup = pageSetUpTearDownGroups.get(group);
            pageGroup.add(page);
        } else {
            LinkedList<WikiPage> pageGroup = new LinkedList<WikiPage>();
            pageGroup.add(page);
            pageSetUpTearDownGroups.put(group, pageGroup);
        }
    }

    private String getSetUpTearDownGroup(WikiPage page) {
        String setUpPath = this.getPathForSetUpTearDown(page, "SuiteSetUp");
        String tearDownPath = this.getPathForSetUpTearDown(page, "SuiteTearDown");
        return setUpPath + "," + tearDownPath;
    }

    private String getPathForSetUpTearDown(WikiPage page, String setUpTearDownName) {
        String path = null;
        WikiPage suiteSetUpTearDown = page.getPageCrawler().getClosestInheritedPage(setUpTearDownName);
        if (suiteSetUpTearDown != null) {
            path = suiteSetUpTearDown.getPageCrawler().getFullPath().toString();
        }
        return path;
    }

    private List<WikiPage> reinsertPagesViaSetUpTearDownGroups(Map<String, LinkedList<WikiPage>> pageSetUpTearDownGroups) {
        LinkedList<WikiPage> pageList = new LinkedList<WikiPage>();
        for (Map.Entry<String, LinkedList<WikiPage>> entry : pageSetUpTearDownGroups.entrySet()) {
            pageList.addAll(this.insertSetUpTearDownPageGroup(entry.getKey(), entry.getValue()));
        }
        return pageList;
    }

    private List<WikiPage> insertSetUpTearDownPageGroup(String setUpAndTearDownGroupKey, LinkedList<WikiPage> pageGroup) {
        LinkedList<WikiPage> pageList = new LinkedList<WikiPage>();
        pageList.addAll(this.setUpForThisGroup(setUpAndTearDownGroupKey));
        pageList.addAll(pageGroup);
        pageList.addAll(this.tearDownForThisGroup(setUpAndTearDownGroupKey));
        return pageList;
    }

    private List<WikiPage> setUpForThisGroup(String setUpAndTearDown) {
        String setUpPath = setUpAndTearDown.split(",")[0];
        WikiPage setUpPage = this.root.getPageCrawler().getPage(PathParser.parse(setUpPath));
        return setUpPage != null ? Arrays.asList(setUpPage) : Collections.emptyList();
    }

    private List<WikiPage> tearDownForThisGroup(String setUpAndTearDownGroupKey) {
        String tearDownPath = setUpAndTearDownGroupKey.split(",")[1];
        WikiPage tearDownPage = this.root.getPageCrawler().getPage(PathParser.parse(tearDownPath));
        return tearDownPage != null ? Arrays.asList(tearDownPage) : Collections.emptyList();
    }
}

