/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.html.HtmlUtil;
import fitnesse.html.template.HtmlPage;
import fitnesse.html.template.PageTitle;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.editing.NewPageResponder;
import fitnesse.responders.editing.SaveRecorder;
import fitnesse.responders.editing.TemplateUtil;
import fitnesse.wiki.MockingPageCrawler;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;

public class EditResponder
implements SecureResponder {
    public static final String CONTENT_INPUT_NAME = "pageContent";
    public static final String TIME_STAMP = "editTime";
    public static final String TICKET_ID = "ticketId";
    public static final String HELP_TEXT = "helpText";
    public static final String SUITES = "suites";
    public static final String PAGE_TYPE = "pageType";
    public static final String PAGE_NAME = "pageName";
    public static final String TEMPLATE_MAP = "templateMap";
    protected String content;
    protected WikiPage page;
    protected WikiPage root;
    protected PageData pageData;
    protected Request request;

    @Override
    public Response makeResponse(FitNesseContext context, Request request) {
        boolean nonExistent = request.hasInput("nonExistent");
        return this.doMakeResponse(context, request, nonExistent);
    }

    public Response makeResponseForNonExistentPage(FitNesseContext context, Request request) {
        return this.doMakeResponse(context, request, true);
    }

    protected Response doMakeResponse(FitNesseContext context, Request request, boolean firstTimeForNewPage) {
        this.initializeResponder(context.getRootPage(), request);
        SimpleResponse response = new SimpleResponse();
        String resource = request.getResource();
        WikiPagePath path = PathParser.parse(resource);
        PageCrawler crawler = this.root.getPageCrawler();
        this.page = crawler.getPage(path, new MockingPageCrawler());
        this.pageData = this.page.getData();
        this.content = this.createPageContent();
        String html = this.doMakeHtml(resource, context, firstTimeForNewPage);
        response.setContent(html);
        response.setMaxAge(0);
        return response;
    }

    protected void initializeResponder(WikiPage root, Request request) {
        this.root = root;
        this.request = request;
    }

    protected String createPageContent() {
        return this.pageData.getContent();
    }

    private String doMakeHtml(String resource, FitNesseContext context, boolean firstTimeForNewPage) {
        HtmlPage html = context.pageFactory.newPage();
        String title = firstTimeForNewPage ? "Page doesn't exist. Edit: " : "Edit: ";
        html.setTitle(title + resource);
        html.setPageTitle(new PageTitle(title + " Page:", PathParser.parse(resource), this.pageData.getAttribute("Suites")));
        html.setMainTemplate("editPage");
        this.makeEditForm(html, resource, firstTimeForNewPage, NewPageResponder.getDefaultContent(this.page));
        return html.html();
    }

    private void makeEditForm(HtmlPage html, String resource, boolean firstTimeForNewPage, String defaultNewPageContent) {
        html.put("resource", resource);
        html.put(TIME_STAMP, String.valueOf(SaveRecorder.timeStamp()));
        html.put(TICKET_ID, String.valueOf(SaveRecorder.newTicket()));
        if (this.request.hasInput("redirectToReferer") && this.request.hasHeader("Referer")) {
            String redirectUrl = this.request.getHeader("Referer");
            int questionMarkIndex = redirectUrl.indexOf("?");
            if (questionMarkIndex > 0) {
                redirectUrl = redirectUrl.substring(0, questionMarkIndex);
            }
            redirectUrl = redirectUrl + "?" + this.request.getInput("redirectAction");
            html.put("redirect", redirectUrl);
        }
        html.put(HELP_TEXT, this.pageData.getAttribute("Help"));
        html.put(TEMPLATE_MAP, TemplateUtil.getTemplateMap(this.page));
        html.put(SUITES, this.pageData.getAttribute("Suites"));
        html.put(CONTENT_INPUT_NAME, HtmlUtil.escapeHTML(firstTimeForNewPage ? defaultNewPageContent : this.content));
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }
}

