/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.fixtures;

import fitnesse.FitNesseExpediter;
import fitnesse.fixtures.FitnesseFixtureContext;
import fitnesse.fixtures.PageCreator;
import fitnesse.fixtures.ResponseExaminer;
import fitnesse.fixtures.ResponseRequester;
import fitnesse.http.MockRequest;
import fitnesse.http.MockResponseSender;
import fitnesse.util.MockSocket;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.SymbolicPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.Tag;
import org.htmlparser.filters.AndFilter;
import org.htmlparser.filters.HasAttributeFilter;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.util.NodeList;
import org.json.JSONObject;

public class PageDriver {
    private PageCreator creator = new PageCreator();
    private ResponseRequester requester = new ResponseRequester();
    private ResponseExaminer examiner = new ResponseExaminer();

    public void createPageWithContent(String pageName, String content) throws Exception {
        this.creator.pageName = pageName;
        this.creator.pageContents = content;
        this.creator.valid();
    }

    public void createPageWithAuthentication(String pageName, String attributes) throws Exception {
        this.creator.pageAttributes = attributes;
        this.creator.pageContents = "nothing";
        this.createPageWithContent(pageName, "");
    }

    public int requestPage(String uri) throws Exception {
        this.requester.uri = uri;
        this.requester.execute();
        return this.requester.status();
    }

    public int requestPageAuthenticatedByUserAndPassword(String uri, String user, String password) throws Exception {
        this.requester.username = user;
        this.requester.password = password;
        return this.requestPage(uri);
    }

    public int requestPageSaveWithContentsByUserAndPassword(String pageName, String contents, String username, String password) throws Exception {
        MockRequest request = new MockRequest();
        if (username != null) {
            request.setCredentials(username, password);
        }
        request.addInput("responder", "saveData");
        request.addInput("editTime", "9999999999999");
        request.addInput("ticketId", "321");
        request.addInput("pageContent", contents);
        request.parseRequestUri("/" + pageName);
        WikiPagePath path = PathParser.parse(request.getResource());
        FitnesseFixtureContext.page = FitnesseFixtureContext.context.getRootPage().getPageCrawler().getPage(path);
        FitNesseExpediter expediter = new FitNesseExpediter(new MockSocket(""), FitnesseFixtureContext.context);
        FitnesseFixtureContext.response = expediter.createGoodResponse(request);
        FitnesseFixtureContext.sender = new MockResponseSender();
        FitnesseFixtureContext.sender.doSending(FitnesseFixtureContext.response);
        return FitnesseFixtureContext.response.getStatus();
    }

    public int requestPageSaveWithContents(String pageName, String contents) throws Exception {
        return this.requestPageSaveWithContentsByUserAndPassword(pageName, contents, null, null);
    }

    public String lastModifiedOfPage(String pageName) throws Exception {
        WikiPage root = FitnesseFixtureContext.context.getRootPage();
        WikiPagePath pagePath = PathParser.parse(pageName);
        WikiPage thePage = root.getPageCrawler().getPage(pagePath);
        PageData data = thePage.getData();
        return data.getAttribute("LastModifyingUser");
    }

    public boolean pageIsASymbolicLink(String pageName) {
        WikiPage root = FitnesseFixtureContext.context.getRootPage();
        WikiPagePath pagePath = PathParser.parse(pageName);
        WikiPage thePage = root.getPageCrawler().getPage(pagePath);
        return thePage instanceof SymbolicPage;
    }

    public boolean pageExists(String pageName) {
        WikiPage root = FitnesseFixtureContext.context.getRootPage();
        WikiPagePath pagePath = PathParser.parse(pageName);
        WikiPage thePage = root.getPageCrawler().getPage(pagePath);
        return thePage != null;
    }

    public void makeATestPage(String pageName) throws Exception {
        this.onPageSetAttribute(pageName, "Test");
    }

    public void makeASuitePage(String pageName) throws Exception {
        this.onPageSetAttribute(pageName, "Suite");
    }

    private void onPageSetAttribute(String pageName, String attrName) {
        WikiPage root = FitnesseFixtureContext.context.getRootPage();
        WikiPagePath pagePath = PathParser.parse(pageName);
        WikiPage thePage = root.getPageCrawler().getPage(pagePath);
        PageData data = thePage.getData();
        data.setAttribute(attrName, "true");
        thePage.commit(data);
    }

    public boolean contentMatches(String pattern) throws Exception {
        this.examiner.type = "contents";
        this.examiner.pattern = pattern;
        return this.examiner.matches();
    }

    public boolean contentContains(String subString) throws Exception {
        this.examiner.type = "contents";
        this.examiner.extractValueFromResponse();
        return this.examiner.getValue().contains(subString);
    }

    public boolean htmlContains(String subString) throws Exception {
        String html = this.requester.html();
        html = html.replaceAll("\n", " ");
        html = html.replaceAll("\r", " ");
        html = html.replaceAll("\\s+", " ");
        System.out.println("html = " + html);
        System.out.println("subString = " + subString);
        return html.contains(subString);
    }

    public boolean containsJsonPacket(String packet) throws Exception {
        packet = ResponseExaminer.convertBreaksToLineSeparators(packet);
        JSONObject expected = new JSONObject(packet);
        String contentString = this.requester.contents();
        int jsonStart = contentString.indexOf("{");
        if (jsonStart == -1) {
            return false;
        }
        contentString = contentString.substring(jsonStart);
        JSONObject actual = new JSONObject(contentString);
        return expected.toString(1).equals(actual.toString(1));
    }

    public String content() throws Exception {
        return this.requester.html();
    }

    public String lineIs(int lineNumber) throws Exception {
        this.examiner.type = "line";
        this.examiner.number = lineNumber;
        return this.examiner.string();
    }

    public int lineNumberContaining(String text) throws Exception {
        String content = this.requester.html();
        int textPosition = content.indexOf(text);
        if (textPosition == -1) {
            return -1;
        }
        String priorToContent = content.substring(0, textPosition);
        String[] lines = priorToContent.split("\n");
        return lines.length;
    }

    public int countOfTagWithIdPrefix(String tag, String idPrefix) throws Exception {
        AndFilter filter = new AndFilter(new TagNameFilter(tag), new HasAttributePrefixFilter("id", idPrefix));
        return this.getMatchingTags(filter).size();
    }

    private NodeList getMatchingTags(NodeFilter filter) throws Exception {
        String html = this.examiner.html();
        Parser parser = new Parser(new Lexer(new Page(html)));
        NodeList list = parser.parse(null);
        NodeList matches = list.extractAllNodesThatMatch(filter, true);
        return matches;
    }

    public String pageHistoryDateSignatureOf(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return dateFormat.format(date);
    }

    public int countOfTagWithClassBelowTagWithIdPrefix(String childTag, String tagClass, String parentTag, String parentIdPrefix) throws Exception {
        NodeList parents = this.getMatchingTags(new AndFilter(new TagNameFilter(parentTag), new HasAttributePrefixFilter("id", parentIdPrefix)));
        NodeFilter[] predicates = new NodeFilter[]{new TagNameFilter(childTag), new HasAttributeFilter("class", tagClass)};
        AndFilter filter = new AndFilter(predicates);
        NodeList matches = parents.extractAllNodesThatMatch(filter, true);
        return matches.size();
    }

    public String valueOfTagWithIdIs(String id) throws Exception {
        return this.getValueOfTagWithAttributeValue("id", id);
    }

    private String getValueOfTagWithAttributeValue(String attribute, String value) throws Exception {
        NodeList matches = this.getMatchingTags(new HasAttributeFilter(attribute, value));
        if (matches.size() != 1) {
            return String.format("There are %d matches, there should be 1.", matches.size());
        }
        return matches.elementAt(0).toHtml();
    }

    public String valueOfTagWithClassIs(String classValue) throws Exception {
        return this.getValueOfTagWithAttributeValue("class", classValue);
    }

    public boolean contentOfTagWithIdContains(String id, String contents) throws Exception {
        String html = this.getValueOfTagWithAttributeValue("id", id);
        return html.contains(contents);
    }

    public String contentOfTagWithId(String id) throws Exception {
        return this.getValueOfTagWithAttributeValue("id", id);
    }

    public boolean pageHasAttribute(String fullPathOfPage, String attribute) throws Exception {
        PageCrawler crawler = FitnesseFixtureContext.context.getRootPage().getPageCrawler();
        WikiPage page = crawler.getPage(PathParser.parse(fullPathOfPage));
        PageData data = page.getData();
        return data.hasAttribute(attribute);
    }

    private static class HasAttributePrefixFilter
    extends HasAttributeFilter {
        private static final long serialVersionUID = 1L;

        public HasAttributePrefixFilter(String attribute, String prefix) {
            super(attribute, prefix);
        }

        @Override
        public boolean accept(Node node) {
            if (!(node instanceof Tag)) {
                return false;
            }
            if (this.mValue == null) {
                return false;
            }
            Tag tag = (Tag)node;
            if (tag.getAttributeEx(this.mAttribute) == null) {
                return false;
            }
            return tag.getAttributeEx(this.mAttribute).getValue().startsWith(this.mValue);
        }
    }
}

