/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.utils;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.xltest.domain.ActiveTestSpecification;
import com.xebialabs.xltest.domain.Report;
import java.util.Collection;
import java.util.regex.Pattern;
import org.modeshape.common.text.Jsr283Encoder;

public class JcrUtils {
    private static final Pattern JCR_NAME_PATTERN = Pattern.compile("^[\\w\\.\\- ]*$");
    private static Jsr283Encoder jsr283Encoder = new Jsr283Encoder();

    public static void addPrefixIfNeeded(ConfigurationItem item) {
        String id = item.getId();
        if (id.startsWith("Configuration") || id.startsWith("Applications") || id.startsWith("Infrastructure")) {
            return;
        }
        String rootNodeName = item.getType().getDescriptor().getRoot().getRootNodeName();
        if (rootNodeName == null) {
            throw new RuntimeException("Type " + item.getType() + " is unrooted!");
        }
        String subdir = "";
        if (item.getType().instanceOf(Type.valueOf(Report.class))) {
            subdir = "Reports";
        }
        if (item.getType().instanceOf(Type.valueOf(ActiveTestSpecification.class))) {
            subdir = "TestSpecifications";
        }
        if (!"".equals(subdir)) {
            subdir = subdir + "/";
        }
        item.setId(rootNodeName + "/" + subdir + id);
    }

    public static void addPrefixIfNeeded(Collection<ConfigurationItem> items) {
        for (ConfigurationItem item : items) {
            JcrUtils.addPrefixIfNeeded(item);
        }
    }

    public static void validateJcrId(ConfigurationItem item) {
        String ciName = item.getName();
        if (!JCR_NAME_PATTERN.matcher(ciName).matches()) {
            Validator.ValidationsFailedException validationsFailedException = new Validator.ValidationsFailedException(item);
            validationsFailedException.add("id [%s] does not match the pattern %s", new Object[]{ciName, JCR_NAME_PATTERN.pattern()});
            throw validationsFailedException;
        }
    }

    public static String encodeJcrId(String toEncode) {
        return jsr283Encoder.encode(toEncode);
    }

    public static String decodeJcrId(String toDecode) {
        return jsr283Encoder.decode(toDecode);
    }

    public static String getName(String jcrId) {
        int idx = jcrId.lastIndexOf(47);
        idx = idx == -1 ? 0 : ++idx;
        return jcrId.substring(idx);
    }

    public static String getParentId(String jcrId) {
        int lastSlashIdx = jcrId.lastIndexOf(47);
        if (lastSlashIdx == -1) {
            throw new IllegalArgumentException("jcrId has no parent: " + jcrId);
        }
        String fullParentId = jcrId.substring(0, lastSlashIdx);
        lastSlashIdx = fullParentId.lastIndexOf(47);
        return fullParentId.substring(lastSlashIdx + 1);
    }

    public static Directory directory(String path) {
        Directory dir = new Directory();
        dir.setId(path);
        return dir;
    }

    private JcrUtils() {
    }
}

