/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.utils;

import com.xebialabs.xlt.plugin.api.resultparser.ImportFailedException;
import com.xebialabs.xlt.plugin.api.resultparser.NothingToImportException;
import com.xebialabs.xlt.plugin.api.resultparser.UnexpectedFormatException;
import com.xebialabs.xlt.plugin.api.testrun.TestRunNotImportedInChronologicalOrderException;
import com.xebialabs.xltest.domain.ExecutionResult;
import com.xebialabs.xltest.service.ExecutionProgressEvent;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutingTestRun {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutingTestRun.class);
    private final String testRunId;
    private final String testSpecificationName;
    private Date startTime;
    private Date finishedTime;
    private String failureReason;
    private boolean qualificationResult = true;
    private long averagePreviousDuration;
    private Future<String> task;
    private Date lastUpdateTime;

    public ExecutingTestRun(String testSpecificationName, String taskId) {
        this.testSpecificationName = testSpecificationName;
        this.testRunId = taskId;
        this.task = null;
    }

    public boolean isTestSpecificationSet() {
        return this.task == null;
    }

    public String getTestRunId() {
        return this.testRunId;
    }

    public String getTestSpecificationName() {
        return this.testSpecificationName;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getFinishedTime() {
        return this.finishedTime;
    }

    public void setFinishedTime(Date finishedTime) {
        this.finishedTime = finishedTime;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public boolean isQualificationResult() {
        return this.qualificationResult;
    }

    public void setQualificationResult(boolean qualificationResult) {
        this.qualificationResult = qualificationResult;
    }

    public long timeElapsed() {
        return new Date().getTime() - this.getStartTime().getTime();
    }

    public long getAveragePreviousDuration() {
        return this.averagePreviousDuration;
    }

    public void setAveragePreviousDuration(long averagePreviousDuration) {
        this.averagePreviousDuration = averagePreviousDuration;
    }

    public Future<String> getTask() {
        return this.task;
    }

    public void setTask(Future<String> task) {
        this.task = task;
    }

    public ExecutionProgressEvent getProgressEvent(long longestAveragePreviousDuration) {
        ExecutionProgressEvent progressEvent = this.handleExceptions();
        if (progressEvent != null) {
            return progressEvent;
        }
        long timeSpent = System.currentTimeMillis() - this.startTime.getTime();
        long timeLeft = longestAveragePreviousDuration - timeSpent;
        int percentage = longestAveragePreviousDuration == 0L ? 100 : (timeLeft > 0L ? Math.min((int)(timeSpent * 100L / longestAveragePreviousDuration), 100) : 200);
        ExecutionResult executionResult = this.getExecutionResult();
        ExecutionResult.ExecutionStatus status = executionResult.getStatus();
        if (status == ExecutionResult.ExecutionStatus.FAILED || status == ExecutionResult.ExecutionStatus.FINISHED) {
            percentage = 100;
        }
        return new ExecutionProgressEvent(this.testSpecificationName, executionResult, timeLeft, percentage);
    }

    public ExecutionResult getExecutionResult() {
        if (this.startTime != null) {
            if (this.finishedTime == null) {
                return ExecutionResult.running(this.timeElapsed());
            }
            return this.qualificationResult ? ExecutionResult.finished() : ExecutionResult.failed(this.failureReason);
        }
        return ExecutionResult.notRunning();
    }

    private ExecutionProgressEvent handleExceptions() {
        if (this.getTask() != null && this.getTask().isDone()) {
            try {
                this.getTask().get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof NothingToImportException) {
                    return new ExecutionProgressEvent(this.testSpecificationName, ExecutionResult.noData(cause.getMessage()), 0L, 100);
                }
                if (cause instanceof TestRunNotImportedInChronologicalOrderException) {
                    return new ExecutionProgressEvent(this.testSpecificationName, ExecutionResult.cannotRewriteHistory(cause.getMessage()), 0L, 100);
                }
                if (cause instanceof UnexpectedFormatException) {
                    return new ExecutionProgressEvent(this.testSpecificationName, ExecutionResult.malformedInput(cause.getMessage()), 0L, 100);
                }
                if (cause instanceof ImportFailedException) {
                    return new ExecutionProgressEvent(this.testSpecificationName, ExecutionResult.failed(cause.getMessage()), 0L, 100);
                }
                LOG.warn("Unknown error while execution: ", (Throwable)e);
                return new ExecutionProgressEvent(this.testSpecificationName, ExecutionResult.unknownError(cause.getMessage() != null ? cause.getMessage() : "Unknown error"), 0L, 100);
            }
        }
        return null;
    }
}

