/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.upgrade.jcr.v130;

import com.google.common.base.Splitter;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlt.plugin.api.testrun.Event;
import com.xebialabs.xltest.domain.Dashboard;
import com.xebialabs.xltest.domain.DashboardTile;
import com.xebialabs.xltest.repository.DashboardRepository;
import com.xebialabs.xltest.repository.EventRepository;
import com.xebialabs.xltest.service.EventBulkProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class ReplaceNameWithHierarchyWithinEventsUpgrade
extends Upgrade {
    private static final Logger LOG = LoggerFactory.getLogger(ReplaceNameWithHierarchyWithinEventsUpgrade.class);
    public static final int BATCH_SIZE = 1000;
    private final EventRepository eventRepository;
    @Autowired
    private DashboardRepository dashboardRepository;

    public Version upgradeVersion() {
        return Version.valueOf((String)"xl-testview", (String)"1.3.0#6");
    }

    @Autowired
    public ReplaceNameWithHierarchyWithinEventsUpgrade(EventRepository eventRepository) {
        this.eventRepository = eventRepository;
    }

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        this.eventRepository.refreshIndex();
        try {
            Map properties = Event.props((Object[])new Object[]{"type", "string", "index", "not_analyzed", "include_in_all", true});
            this.eventRepository.updateMapping("functionalResult", "@hierarchy", properties);
            this.eventRepository.bulkUpdate("@type:functionalResult", 1000, new ExtractNameIntoHierarchyProcessor());
            List<Dashboard> dashboards = this.dashboardRepository.getAll();
            for (Dashboard dashboard : dashboards) {
                Dashboard fullDashboard = this.dashboardRepository.getById(dashboard.getId());
                for (DashboardTile dashboardTile : fullDashboard.getDashboardTiles()) {
                    dashboardTile.setDrillDownPrefix(this.updateDrillDownPrefix(dashboardTile.getDrillDownPrefix()));
                }
                this.dashboardRepository.update(fullDashboard.getId(), fullDashboard);
            }
        }
        catch (Exception e) {
            throw new UpgradeException("Unable to perform upgrade", e);
        }
        this.eventRepository.refreshIndex();
        return true;
    }

    private String updateDrillDownPrefix(String originalDrillDownPrefix) {
        if (originalDrillDownPrefix == null) {
            return null;
        }
        if (StringUtils.isEmpty((Object)originalDrillDownPrefix)) {
            return "";
        }
        if (originalDrillDownPrefix.endsWith(";")) {
            return originalDrillDownPrefix.substring(0, originalDrillDownPrefix.length() - 1);
        }
        return originalDrillDownPrefix;
    }

    public static List<String> extractHierarchy(String eventName, char separator) {
        return Splitter.on((char)separator).splitToList((CharSequence)eventName);
    }

    class ExtractNameIntoHierarchyProcessor
    implements EventBulkProcessor {
        ExtractNameIntoHierarchyProcessor() {
        }

        @Override
        public void process(List<Event> events) {
            LOG.debug("ExtractNameIntoHierarchyProcessor, Processing {} events.", (Object)events.size());
            for (Event event : events) {
                LOG.debug("Event before processing: {}", (Object)event);
                String eventName = (String)event.get("name");
                if (event.getHierarchy().isEmpty() && !StringUtils.isEmpty((Object)eventName)) {
                    event.update("@hierarchy", new ArrayList<String>(ReplaceNameWithHierarchyWithinEventsUpgrade.extractHierarchy(eventName, ';')));
                }
                event.remove("name");
                LOG.debug("Event after processing (not saved!): {}", (Object)event);
            }
            for (Event e : events) {
                LOG.debug("Persisting event: {}", (Object)e);
                ReplaceNameWithHierarchyWithinEventsUpgrade.this.eventRepository.updateAndPersist(e);
            }
        }
    }
}

