/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.service;

import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlt.plugin.api.resultparser.ImportException;
import com.xebialabs.xltest.repository.HostRepository;
import com.xebialabs.xltest.utils.glob.FileMatcher;
import com.xebialabs.xltest.utils.glob.Globbit;
import com.xebialabs.xltest.utils.glob.OverthereFileComparator;
import java.util.SortedSet;
import java.util.TreeSet;

public class TestResultLocator {
    private Host host;

    public TestResultLocator forHost(String type, String address, String username, String password) {
        this.host = HostRepository.create(type, address, username, password);
        return this;
    }

    public SortedSet<OverthereFile> locate(String baseDir, String pattern) throws ImportException {
        OverthereConnection connection = this.host.getConnection();
        return this.getParents(Globbit.find(connection.getFile(baseDir), new FileMatcher(pattern), Globbit.GlobMode.FILES_AND_DIRECTORIES));
    }

    private SortedSet<OverthereFile> getParents(SortedSet<OverthereFile> files) {
        TreeSet<OverthereFile> result = new TreeSet<OverthereFile>(new OverthereFileComparator());
        for (OverthereFile f : files) {
            if (f.isDirectory()) {
                result.add(f);
                continue;
            }
            result.add(f.getParentFile());
        }
        return result;
    }

    public Host getHost() {
        return this.host;
    }
}

