/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.service;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlt.plugin.api.resultparser.ImportException;
import com.xebialabs.xlt.plugin.api.resultparser.NothingToImportException;
import com.xebialabs.xlt.plugin.api.resultparser.TestResultParser;
import com.xebialabs.xlt.plugin.api.resultparser.TestResultParserDriver;
import com.xebialabs.xlt.plugin.api.testrun.Event;
import com.xebialabs.xlt.plugin.api.testrun.TestRunsRepository;
import com.xebialabs.xltest.domain.ActiveTestSpecification;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.domain.Qualification;
import com.xebialabs.xltest.domain.QualificationResult;
import com.xebialabs.xltest.domain.Qualifier;
import com.xebialabs.xltest.domain.TestToolFactory;
import com.xebialabs.xltest.domain.TestToolNameAware;
import com.xebialabs.xltest.repository.EventRepository;
import com.xebialabs.xltest.repository.TestSpecificationRepository;
import com.xebialabs.xltest.repository.TestToolRepository;
import com.xebialabs.xltest.service.ConcurrentImportException;
import com.xebialabs.xltest.utils.glob.FileMatcher;
import com.xebialabs.xltest.utils.glob.Globbit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImportService {
    private static final Logger LOG = LoggerFactory.getLogger(ImportService.class);
    private final TestToolRepository testToolRepository;
    private final EventRepository eventRepository;
    private final TestRunsRepository testRunsRepository;
    private final TestSpecificationRepository testSpecificationRepository;
    private final ConcurrentHashMap<String, AtomicBoolean> currentlyImporting = new ConcurrentHashMap();

    @Autowired
    public ImportService(TestToolRepository testToolRepository, TestRunsRepository testRunsRepository, EventRepository eventRepository, TestSpecificationRepository testSpecificationRepository) {
        this.testToolRepository = testToolRepository;
        this.testRunsRepository = testRunsRepository;
        this.eventRepository = eventRepository;
        this.testSpecificationRepository = testSpecificationRepository;
    }

    public void importTestResults(BaseTestSpecification testSpecification, String testRunId, OverthereFile resultsSearchRoot, Map<String, Object> metadata) throws ImportException {
        LOG.debug("importTestResults(spec={}, testRunId={} )", (Object)testSpecification.getName(), (Object)testRunId);
        if (!(testSpecification instanceof TestToolNameAware)) {
            throw new IllegalArgumentException("Can only import results from test specifications that are TestToolNameAware!");
        }
        FileMatcher fileMatcher = new FileMatcher("**/*");
        this.importTestResults(testSpecification, testRunId, resultsSearchRoot, fileMatcher, metadata);
    }

    public void importTestResults(ActiveTestSpecification testSpecification, String testRunId, OverthereFile resultsSearchRoot) throws ImportException {
        LOG.debug("importTestResults(spec={}, testRunId={} )", (Object)testSpecification.getName(), (Object)testRunId);
        FileMatcher fileMatcher = new FileMatcher(testSpecification.getSearchPattern());
        this.importTestResults(testSpecification, testRunId, resultsSearchRoot, fileMatcher, Collections.emptyMap());
    }

    private SortedSet<OverthereFile> globFiles(OverthereFile root, FileMatcher matcher, Globbit.GlobMode globMode) throws NothingToImportException {
        SortedSet<OverthereFile> overthereFiles = Globbit.find(root, matcher, globMode);
        if (overthereFiles.isEmpty()) {
            throw new NothingToImportException(String.format("No test results found in '%s' with pattern '%s'", root, matcher));
        }
        return overthereFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importTestResults(BaseTestSpecification testSpecification, String testRunId, OverthereFile resultsSearchRoot, FileMatcher fileMatcher, Map<String, Object> metadata) throws ImportException {
        if (!this.setImporting(testSpecification.getId())) {
            throw new ConcurrentImportException();
        }
        LOG.debug("importLatestResults(testSpecId={})", (Object)testSpecification.getName());
        try {
            TestToolFactory scriptableTestTool = this.testToolRepository.findTestToolConfigurationByName(((TestToolNameAware)((Object)testSpecification)).getTestToolName());
            TestResultParser testResultParser = scriptableTestTool.create(testSpecification, resultsSearchRoot, this.eventRepository);
            TestResultParserDriver testResultParserDriver = new TestResultParserDriver(testResultParser);
            SortedSet<OverthereFile> filesToImport = this.globFiles(resultsSearchRoot, fileMatcher, scriptableTestTool.getGlobMode());
            LOG.debug("Found {} files to import. Sending them to the runner", (Object)filesToImport.size());
            List runs = testResultParserDriver.run(filesToImport, testSpecification.getName());
            if (runs.isEmpty()) {
                throw new NothingToImportException("No new test results are found.");
            }
            for (List run : runs) {
                this.enrichEventsWithCustomMetaData(run, metadata);
                this.eventRepository.insertRun(run);
                this.qualifyRun(testSpecification, run);
            }
        }
        finally {
            this.currentlyImporting.get(testSpecification.getId()).set(false);
            if (resultsSearchRoot != null) {
                resultsSearchRoot.getConnection().close();
            }
        }
    }

    private void qualifyRun(BaseTestSpecification testSpecification, List<Event> run) {
        Qualification qualification = testSpecification.getQualification();
        if (qualification != null) {
            Qualifier qualifier = qualification.getQualifier(testSpecification, run.get(0).getTestRunId(), this.testRunsRepository);
            QualificationResult qualificationResult = qualifier.getQualificationResult(run);
            this.testSpecificationRepository.addQualificationResult(qualificationResult);
        }
    }

    private void enrichEventsWithCustomMetaData(List<Event> events, Map<String, Object> metadata) {
        for (Event event : events) {
            event.updateWithProperties(metadata);
        }
    }

    private synchronized boolean setImporting(String testSpecId) {
        if (!this.currentlyImporting.containsKey(testSpecId)) {
            this.currentlyImporting.put(testSpecId, new AtomicBoolean(true));
            return true;
        }
        return this.currentlyImporting.get(testSpecId).compareAndSet(false, true);
    }
}

