/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.repository;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.xlt.plugin.api.testrun.Event;
import com.xebialabs.xlt.plugin.api.testrun.TestRun;
import com.xebialabs.xlt.plugin.api.testrun.TestRunsRepository;
import com.xebialabs.xltest.domain.QualificationResult;
import com.xebialabs.xltest.domain.TestRunImpl;
import com.xebialabs.xltest.repository.EventRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.query.AndFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.RangeFilterBuilder;
import org.elasticsearch.index.query.TermFilterBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class TestRunsRepositoryImpl
implements TestRunsRepository {
    private static Logger LOG = LoggerFactory.getLogger(TestRunsRepositoryImpl.class);
    private final EventRepository eventRepository;
    private final RepositoryService repository;

    @Autowired
    public TestRunsRepositoryImpl(EventRepository eventRepository, RepositoryService repository) {
        this.eventRepository = eventRepository;
        this.repository = repository;
    }

    public TestRun getTestRun(String testRunId) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("@runId", testRunId.toString());
        FilterBuilder query = TestRunsRepositoryImpl.constructSearchQuery(null, queryParams);
        List<Event> events = this.eventRepository.query(query);
        SearchParameters sp = new SearchParameters();
        sp.setType(Type.valueOf(QualificationResult.class));
        sp.setName(testRunId);
        List qualificationResults = this.repository.listEntities(sp);
        if (qualificationResults.size() == 1) {
            return new TestRunImpl(events, (QualificationResult)((Object)qualificationResults.get(0)));
        }
        return new TestRunImpl(events);
    }

    private FilterBuilder constructQuery(long startTime, long endTime, Map<String, Object> queryParameters) {
        return TestRunsRepositoryImpl.constructSearchQuery((FilterBuilder)FilterBuilders.rangeFilter((String)"@createdAt").gte(startTime).lte(endTime), queryParameters);
    }

    public static FilterBuilder constructSearchQuery(FilterBuilder initialFilterBuilder, Map<String, Object> queryParameters) {
        ArrayList<Object> filterBuilders = new ArrayList<Object>(queryParameters.size() + 1);
        if (initialFilterBuilder != null) {
            filterBuilders.add(initialFilterBuilder);
        }
        for (Map.Entry<String, Object> entry : queryParameters.entrySet()) {
            Object value = entry.getValue();
            if (TestRunsRepositoryImpl.isStringValue(value)) {
                filterBuilders.add(FilterBuilders.termFilter((String)entry.getKey(), (Object)value));
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                if (collection.isEmpty()) continue;
                ArrayList values = new ArrayList(collection);
                filterBuilders.add(FilterBuilders.termsFilter((String)entry.getKey(), (Object[])values.toArray()).execution("and"));
                continue;
            }
            throw new IllegalArgumentException(String.format("Unsupported type %s in constructSearchQuery().", value.getClass().getSimpleName()));
        }
        AndFilterBuilder searchFilter = FilterBuilders.andFilter((FilterBuilder[])filterBuilders.toArray(new FilterBuilder[filterBuilders.size()]));
        LOG.trace("search filter = {}", (Object)searchFilter);
        return searchFilter;
    }

    private static boolean isStringValue(Object value) {
        return value instanceof String && Strings.hasText((String)((String)value));
    }

    private List<Event> getEventsBetweenByType(long startTime, long endTime, String eventType, Map<String, Object> queryParameters) {
        HashMap<String, Object> startTestRunQuery = new HashMap<String, Object>(queryParameters);
        startTestRunQuery.put("@type", eventType);
        FilterBuilder query = this.constructQuery(startTime, endTime, startTestRunQuery);
        return this.eventRepository.query(query);
    }

    public Event getLatestEventOfType(String testSpecification, String eventType, long fromDate, long endDate) {
        HashMap<String, Object> latestEventsQuery = new HashMap<String, Object>();
        latestEventsQuery.put("@type", eventType);
        latestEventsQuery.put("@testSpecification", testSpecification);
        FilterBuilder query = this.constructQuery(fromDate, endDate, latestEventsQuery);
        return this.eventRepository.fetchLatest(query);
    }

    public TestRun getLatestTestRun(String testSpecification, long fromDate) {
        return this.getLatestTestRun(testSpecification, fromDate, System.currentTimeMillis());
    }

    public TestRun getLatestTestRun(String testSpecification, long fromDate, long endDate) {
        LOG.debug("getLatestTestRun: testSpecification={} from={} to={}", new Object[]{testSpecification, fromDate, endDate});
        Event executionStartedEvent = this.getLatestEventOfType(testSpecification, "executionStarted", fromDate, endDate);
        Event importStartedEvent = this.getLatestEventOfType(testSpecification, "importStarted", fromDate, endDate);
        if (executionStartedEvent != null && importStartedEvent == null) {
            return this.getTestRun(executionStartedEvent.getTestRunId());
        }
        if (importStartedEvent != null) {
            return this.getTestRun(importStartedEvent.getTestRunId());
        }
        return null;
    }

    public List<TestRun> getTestRunsBetween(String testSpecificationName, long startTime, long endTime) {
        HashMap<String, Object> eventsByTestSpecification = new HashMap<String, Object>();
        eventsByTestSpecification.put("@testSpecification", testSpecificationName);
        return this.getTestRuns(eventsByTestSpecification, Math.min(startTime, endTime), Math.max(startTime, endTime));
    }

    public List<TestRun> getTestRuns(Map<String, Object> queryParameters, long startTime, long endTime) {
        List<Event> allStartEventsAsList = this.getEventsBetweenByType(startTime, endTime, "executionStarted", queryParameters);
        Map<String, Event> startEvents = this.getAllEventsAsMap(allStartEventsAsList);
        List<Event> allImportStartedEvents = this.getEventsBetweenByType(startTime, endTime, "importStarted", queryParameters);
        Map<String, Event> importStartedEvents = this.getAllEventsAsMap(allImportStartedEvents);
        Set<String> allIds = this.getAllUuids(startEvents, importStartedEvents);
        ArrayList<TestRun> testRuns = new ArrayList<TestRun>();
        for (String uuid : allIds) {
            testRuns.add(this.getTestRun(uuid));
        }
        Collections.sort(testRuns, new Comparator<TestRun>(){

            @Override
            public int compare(TestRun o1, TestRun o2) {
                Date startTime1 = o1.getStartTime() != null ? o1.getStartTime() : new Date(0L);
                Date startTime2 = o2.getStartTime() != null ? o2.getStartTime() : new Date(0L);
                return startTime1.compareTo(startTime2);
            }
        });
        return testRuns;
    }

    private Set<String> getAllUuids(Map<String, Event> startEvents, Map<String, Event> importStartedEvents) {
        HashSet<String> allUuids = new HashSet<String>();
        allUuids.addAll(startEvents.keySet());
        allUuids.addAll(importStartedEvents.keySet());
        return allUuids;
    }

    private Map<String, Event> getAllEventsAsMap(List<Event> events) {
        HashMap<String, Event> map = new HashMap<String, Event>();
        for (Event ev : events) {
            map.put(ev.getTestRunId(), ev);
        }
        return map;
    }

    public List<TestRun> getPreviousTestRuns(TestRun testRun, int max) {
        LOG.debug("getPreviousTestRuns testRun={} max={}", (Object)testRun, (Object)max);
        RangeFilterBuilder rangeFilter = FilterBuilders.rangeFilter((String)"@testedAt").lt(testRun.getStartTime().getTime());
        return this.getTestRuns(testRun, (FilterBuilder)rangeFilter, max, SortOrder.DESC);
    }

    public List<TestRun> getLaterTestRuns(TestRun testRun, int max) {
        LOG.debug("getLaterTestRuns testRun={} max={}", (Object)testRun, (Object)max);
        RangeFilterBuilder rangeFilter = FilterBuilders.rangeFilter((String)"@testedAt").gt(testRun.getStartTime().getTime());
        return this.getTestRuns(testRun, (FilterBuilder)rangeFilter, max, SortOrder.ASC);
    }

    private List<TestRun> getTestRuns(TestRun testRun, FilterBuilder rangeFilter, int max, SortOrder sortOrder) {
        TermFilterBuilder typesFilter = FilterBuilders.termFilter((String)"@type", (String)"importStarted");
        TermFilterBuilder testSpecFilter = FilterBuilders.termFilter((String)"@testSpecification", (String)testRun.getTestSpecificationName());
        AndFilterBuilder theFilter = FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{testSpecFilter, typesFilter, rangeFilter});
        LOG.debug("filter={}", (Object)theFilter);
        List<Event> importStartedEvents = this.eventRepository.query((FilterBuilder)theFilter, (SortBuilder)SortBuilders.fieldSort((String)"@testedAt").order(sortOrder), max);
        return Lists.transform(importStartedEvents, (Function)new Function<Event, TestRun>(){

            public TestRun apply(Event ev) {
                return TestRunsRepositoryImpl.this.getTestRun(ev.getTestRunId());
            }
        });
    }

    public List<Event> getEventsBetween(long startTime, long endTime, Map<String, Object> propertyFilter) {
        FilterBuilder query = this.constructQuery(startTime, endTime, propertyFilter);
        return this.eventRepository.query(query);
    }

    @Deprecated
    public List<Event> getResultEventsThatChangedFromLastRun(TestRun testRun) {
        List<TestRun> oneRunBefore = this.getPreviousTestRuns(testRun, 1);
        if (oneRunBefore.isEmpty()) {
            return Lists.newArrayList();
        }
        TestRun oldTestRun = oneRunBefore.get(0);
        Predicate<Event> containingHierarchyAndResult = new Predicate<Event>(){

            public boolean apply(Event event) {
                return event.hasProperty("@hierarchy") && event.hasProperty("@result");
            }
        };
        Function<Event, String> eventIndexFn = new Function<Event, String>(){

            public String apply(Event event) {
                return Joiner.on((char)';').join((Iterable)event.get("@hierarchy"));
            }
        };
        Collection events = Collections2.filter(this.getEventsForTestRun(testRun, Collections.emptyMap()), (Predicate)containingHierarchyAndResult);
        Collection oldEvents = Collections2.filter(this.getEventsForTestRun(oldTestRun, Collections.emptyMap()), (Predicate)containingHierarchyAndResult);
        ImmutableMap events_map = Maps.uniqueIndex((Iterable)events, (Function)eventIndexFn);
        ImmutableMap oldEvents_map = Maps.uniqueIndex((Iterable)oldEvents, (Function)eventIndexFn);
        ArrayList<Event> deltaEvents = new ArrayList<Event>(100);
        for (Event ev : events_map.values()) {
            String name = Joiner.on((char)';').join((Iterable)ev.get("@hierarchy"));
            if (!oldEvents_map.containsKey(name) || ev.getResult().equals(((Event)oldEvents_map.get(name)).get("@result"))) continue;
            deltaEvents.add(ev);
        }
        return deltaEvents;
    }

    public List<Event> getEventsForTestRun(TestRun testRun, Map<String, Object> eventProperties) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        if (eventProperties != null) {
            queryParams.putAll(eventProperties);
        }
        queryParams.put("@runId", testRun.getId());
        FilterBuilder query = TestRunsRepositoryImpl.constructSearchQuery(null, queryParams);
        return this.eventRepository.query(query);
    }

    public void refreshIndex() {
        this.eventRepository.refreshIndex();
    }
}

