/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlt.plugin.api.resultparser.ImportException;
import com.xebialabs.xlt.plugin.api.resultparser.ImportFailedException;
import com.xebialabs.xlt.plugin.api.resultparser.TestResultParser;
import com.xebialabs.xlt.plugin.api.resultparser.TestRunHistorian;
import com.xebialabs.xlt.plugin.api.resultparser.TestRunHistorianAware;
import com.xebialabs.xlt.plugin.api.testrun.Event;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.domain.ScriptedConfigurationItem;
import com.xebialabs.xltest.domain.TestToolFactory;
import com.xebialabs.xltest.repository.EventRepository;
import com.xebialabs.xltest.repository.ScriptExecutionException;
import com.xebialabs.xltest.service.TestRunHistorianImpl;
import com.xebialabs.xltest.utils.glob.Globbit;
import java.io.FileNotFoundException;
import java.util.List;
import javax.script.ScriptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(description="A configuration for a test tool", root=Metadata.ConfigurationItemRoot.CONFIGURATION, virtual=true, versioned=false)
public class TestToolConfiguration
extends ScriptedConfigurationItem
implements TestToolFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TestToolConfiguration.class);
    @Property(description="The type of test tool: performance or functional", defaultValue="functional")
    private String category;
    @Property(description="Default search pattern to find readable files.", defaultValue="**/*")
    private String defaultSearchPattern;
    @Property(description="Language which implements the TestTool, either java or python", defaultValue="python")
    private String language;
    @Property(description="If language is Java, name of class i.e. com.xebialabs.xltest.testtools.FitNesseGreatPowerTestTool", defaultValue="")
    private String className;
    @Property(description="define the mode for filtering files: files-only, directories-only or files-and-directories", defaultValue="files-only")
    private String globMode;

    @Override
    public TestResultParser create(final BaseTestSpecification testSpecification, final OverthereFile workingDirectory, EventRepository eventRepository) {
        final TestRunHistorianImpl testRunHistorian = new TestRunHistorianImpl(testSpecification, eventRepository);
        if ("java".equalsIgnoreCase(this.language)) {
            try {
                Class<?> clazz = Class.forName(this.className);
                TestResultParser tool = (TestResultParser)clazz.newInstance();
                if (tool instanceof TestRunHistorianAware) {
                    TestRunHistorianAware javaTool = (TestRunHistorianAware)tool;
                    javaTool.setTestRunHistorian((TestRunHistorian)testRunHistorian);
                }
                return tool;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Class '" + this.className + "' is not a TestResultParser");
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Cannot find class for property classPath '" + this.className + "'");
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Unable to instantiate classPath '" + this.className + "'");
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("IllegalAccess to classPath '" + this.className + "'");
            }
        }
        if ("python".equalsIgnoreCase(this.language)) {
            return new TestResultParser(){

                public List<List<Event>> generateEventsFromFiles(List<OverthereFile> testResultFiles) throws ImportException {
                    ScriptContext context = TestToolConfiguration.this.newScriptContext();
                    try {
                        context.setAttribute("files", testResultFiles, 100);
                        context.setAttribute("test_specification", (Object)testSpecification, 100);
                        context.setAttribute("working_directory", workingDirectory, 100);
                        context.setAttribute("test_run_historian", testRunHistorian, 100);
                        return (List)TestToolConfiguration.this.execute(context, TestToolConfiguration.this);
                    }
                    catch (ScriptExecutionException e) {
                        LOG.warn(e.getMessage());
                        if (e.getScriptCause() instanceof ImportException) {
                            throw (ImportException)e.getScriptCause();
                        }
                        throw new ImportFailedException(e.getCause());
                    }
                    catch (FileNotFoundException fnfe) {
                        LOG.error("Error generating test tool. File not found: {}", (Object)fnfe.getMessage());
                        throw new RuntimeException("Error generating test tool.", fnfe);
                    }
                    catch (Exception e) {
                        LOG.error("Error generating import. error: {}", (Object)e.getMessage());
                        throw new RuntimeException("Error generating import.", e);
                    }
                }
            };
        }
        throw new IllegalArgumentException("Language property '" + this.language + "' is not supported. Choose 'java' or 'python'");
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    public static TestToolConfiguration newInstance(String id) {
        return (TestToolConfiguration)Type.valueOf((String)"xlt", (String)TestToolConfiguration.class.getSimpleName()).getDescriptor().newInstance(id);
    }

    public String getTestToolName() {
        return this.getType().getDescriptor().getLabel();
    }

    public String getDescription() {
        return this.getType().getDescriptor().getDescription();
    }

    @Override
    public String getDefaultSearchPattern() {
        return this.defaultSearchPattern;
    }

    @Override
    public Globbit.GlobMode getGlobMode() {
        switch (this.globMode.toLowerCase()) {
            case "files-only": {
                return Globbit.GlobMode.FILES_ONLY;
            }
            case "directories-only": {
                return Globbit.GlobMode.DIRECTORIES_ONLY;
            }
            case "files-and-directories": {
                return Globbit.GlobMode.FILES_AND_DIRECTORIES;
            }
        }
        throw new IllegalArgumentException(String.format("Glob mode %s is invalid. Use one of 'files-only', 'directories-only' or 'files-and-directories'", new Object[0]));
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }
}

