/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.configuration;

import com.typesafe.config.Config;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.core.rest.api.MetadataServiceImpl;
import com.xebialabs.deployit.engine.api.MetadataService;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.repository.JcrRepositoryService;
import com.xebialabs.deployit.repository.RepositoryAdapter;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.deployit.upgrade.Upgrader;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.license.service.LicenseServiceImpl;
import com.xebialabs.xlplatform.jcr.ModeShapeRepositoryFactoryBean;
import com.xebialabs.xlplatform.repository.XlRepositoryConfig;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlt.plugin.api.testrun.TestRunsRepository;
import com.xebialabs.xltest.SystemProperties;
import com.xebialabs.xltest.configuration.SpringContextHolder;
import com.xebialabs.xltest.repository.EventRepository;
import com.xebialabs.xltest.repository.EventRepositoryImpl;
import com.xebialabs.xltest.repository.ValidatingRepository;
import com.xebialabs.xltest.service.ReportService;
import com.xebialabs.xltest.service.licenseinstallservice.LicenseInstallService;
import com.xebialabs.xltest.service.licenseinstallservice.LicenseInstallServiceImpl;
import com.xebialabs.xltest.upgrade.jcr.XlTestViewUpgrader;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.crypto.SecretKey;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import org.elasticsearch.client.Client;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(value={"com.xebialabs.deployit.service.validation", "com.xebialabs.xlplatform.upgrade", "com.xebialabs.xltest.api", "com.xebialabs.xltest.serialize", "com.xebialabs.xltest.service", "com.xebialabs.xltest.repository"})
public class CommonContextConfig {
    @Bean(name={"xlt.license.server-url"})
    public String licenseServerUrl() {
        return this.config().getString("xlt.license.server-url");
    }

    @Bean(name={"xlt.license.file"})
    public String licenseFile() {
        return this.config().getString("xlt.license.file");
    }

    @Bean(name={"xlt.elasticsearch.data"})
    public String elasticSearchBaseDir() {
        return this.config().getString("xlt.elasticsearch.data");
    }

    @Bean(name={"xlt.elasticsearch.http"})
    public boolean elasticSearchHttpServer() {
        return this.config().getBoolean("xlt.elasticsearch.http");
    }

    @Bean(name={"xlt.elasticsearch.port-range"})
    public String elasticSearchPort() {
        return this.config().getString("xlt.elasticsearch.port-range");
    }

    @Bean(name={"xlt.authentication.method"})
    public String authenticationMethod() {
        return this.config().getString("xlt.authentication.method");
    }

    @Bean(name={"xlt.truststore.location"})
    public String keystoreLocation() {
        return this.config().getString("xlt.truststore.location");
    }

    @Bean
    public MetadataService metadataService() {
        return new MetadataServiceImpl();
    }

    @Bean
    public Repository repository(RepositoryService repositoryService, Validator validator) {
        return new RepositoryAdapter(repositoryService, validator, null);
    }

    @Bean
    public RepositoryServiceHolder repositoryServiceHolder(RepositoryService repositoryService) {
        return new RepositoryServiceHolder(repositoryService);
    }

    @Bean
    public LicenseService licenseService() throws IOException {
        return new LicenseServiceImpl(this.licenseFile(), "XL TestView", "3");
    }

    @Bean
    public LicenseInstallService licenseInstallService(LicenseService licenseService) {
        return new LicenseInstallServiceImpl(this.licenseFile(), licenseService, this.licenseServerUrl());
    }

    @Bean
    public ServerConfiguration serverConfiguration() {
        ServerConfiguration serverCfg = new ServerConfiguration();
        serverCfg.setDefaults();
        return serverCfg;
    }

    @Bean
    public RepositoryService repositoryService(JcrTemplate jcrTemplate, Validator validator) throws IOException, RepositoryException {
        SecretKey secretKey = DeployitKeys.getPasswordEncryptionKey((String)"keyStorePassword");
        PasswordEncrypter.init((SecretKey)secretKey);
        PasswordEncrypter passwordEncrypter = PasswordEncrypter.getInstance();
        JcrRepositoryService jcrRepositoryService = new JcrRepositoryService(jcrTemplate, passwordEncrypter, this.licenseService());
        jcrRepositoryService.initializeLicenseValidator();
        return new ValidatingRepository((RepositoryService)jcrRepositoryService, validator);
    }

    @Bean
    @Autowired
    public JcrTemplate jcrTemplate(javax.jcr.Repository jcrRepository, XlRepositoryConfig repositoryConfig) {
        return new JcrTemplate(jcrRepository, (Credentials)repositoryConfig.credentials().get());
    }

    @Bean
    @Autowired
    public ModeShapeRepositoryFactoryBean getModeShapeFactory(XlRepositoryConfig repositoryConfig) {
        ModeShapeRepositoryFactoryBean factory = new ModeShapeRepositoryFactoryBean(repositoryConfig);
        return factory;
    }

    @Bean
    public EventRepository eventRepository(Client client) throws NoSuchMethodException {
        return new EventRepositoryImpl(client);
    }

    @Bean
    public ReportService reportService(TestRunsRepository testRunsRepository, AutowireCapableBeanFactory beanFactory) {
        return new ReportService(testRunsRepository, beanFactory);
    }

    @Bean
    public ExecutorService executorService() {
        return Executors.newCachedThreadPool();
    }

    @Bean
    public SpringContextHolder springContextHolder() {
        return new SpringContextHolder();
    }

    @Bean
    public Upgrader upgrader(JcrTemplate jcrTemplate, RepositoryVersionService repositoryVersionService) {
        return new XlTestViewUpgrader(jcrTemplate, repositoryVersionService);
    }

    @Bean
    public Config config() {
        Config config = SystemProperties.getConfig();
        return config;
    }
}

