/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/api/internal/metadata")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@NoCache
public class MetadataController {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataController.class);
    private static final Predicate<Descriptor> NO_VIRTUAL_TYPES = new Predicate<Descriptor>(){

        public boolean apply(Descriptor input) {
            return !input.isVirtual();
        }
    };

    @GET
    @Path(value="type")
    public List<Descriptor> listDescriptors(@QueryParam(value="superType") Type type) {
        ArrayList descriptors = Lists.newArrayList((Iterable)Collections2.filter((Collection)DescriptorRegistry.getDescriptors(), NO_VIRTUAL_TYPES));
        LOG.debug("findDescriptor: {}", (Object)type);
        ArrayList<Descriptor> result = new ArrayList<Descriptor>();
        if (type == null) {
            result.addAll(descriptors);
        } else {
            for (Descriptor descriptor : descriptors) {
                if (!descriptor.getType().equals((Object)type) && !descriptor.getSuperClasses().contains(type)) continue;
                result.add(descriptor);
            }
        }
        Collections.sort(result, new Comparator<Descriptor>(){

            @Override
            public int compare(Descriptor o1, Descriptor o2) {
                return o1.getType().getName().compareTo(o2.getType().getName());
            }
        });
        return result;
    }

    @GET
    @Path(value="type/{type}")
    public Descriptor findDescriptor(@PathParam(value="type") Type type) {
        LOG.debug("findDescriptor: {}", (Object)type);
        return DescriptorRegistry.getDescriptor((Type)type);
    }
}

