/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xlt.plugin.api.resultparser.ImportException;
import com.xebialabs.xltest.domain.ActiveTestSpecification;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.repository.TestSpecificationRepository;
import com.xebialabs.xltest.service.ExecutableAlreadyRunningException;
import com.xebialabs.xltest.service.ImportService;
import com.xebialabs.xltest.service.execution.TestSpecificationExecutor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartInput;
import org.jboss.resteasy.util.GenericType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.FileSystemUtils;

@Controller
@Path(value="/api/internal/import")
@Produces(value={"application/json"})
@NoCache
public class ImportController {
    private static final Logger LOG = LoggerFactory.getLogger(ImportController.class);
    public static final String REMOTE_TRACKING_ID = "XL_TEST_RUN_ID";
    public static final MediaType ZIP_TYPE = MediaType.valueOf((String)"application/zip");
    private final TestSpecificationRepository testSpecifications;
    private final ImportService importService;
    private final TestSpecificationExecutor testSpecificationExecutor;

    @Autowired
    public ImportController(TestSpecificationRepository testSpecificationRepository, ImportService importService, TestSpecificationExecutor testSpecificationExecutor) {
        this.testSpecifications = testSpecificationRepository;
        this.importService = importService;
        this.testSpecificationExecutor = testSpecificationExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/{testSpecificationId:.+}")
    @Consumes(value={"multipart/mixed"})
    public Response importTestResultsSentByJenkins(@PathParam(value="testSpecificationId") String testSpecificationId, MultipartInput parts, @Context HttpServletRequest request) throws Exception {
        try (InputStream testResultStream = null;){
            LOG.info("Received import for testSpecificationId={}", (Object)testSpecificationId);
            if (parts.getParts().size() != 2) {
                throw new IllegalArgumentException("Expect exactly 2 multipart parts");
            }
            Map metadata = null;
            for (InputPart part : parts.getParts()) {
                if (MediaType.APPLICATION_JSON_TYPE.isCompatible(part.getMediaType())) {
                    metadata = (Map)part.getBody((GenericType)new GenericType<Map<String, Object>>(){});
                    LOG.debug("import metadata={}", (Object)metadata);
                    continue;
                }
                if (ZIP_TYPE.isCompatible(part.getMediaType())) {
                    testResultStream = (InputStream)part.getBody((GenericType)new GenericType<InputStream>(){});
                    continue;
                }
                throw new IllegalArgumentException(String.format("received unsupported media type [%s] for multipart item", part.getMediaType()));
            }
            BaseTestSpecification testSpecification = this.testSpecifications.getById(testSpecificationId);
            Map<String, Object> eventData = this.buildEventData(testSpecification, metadata);
            String testRunId = UUID.randomUUID().toString();
            this.processTestRunData(testSpecification, testRunId, eventData, testResultStream);
            JSONObject response = new JSONObject();
            response.accumulate("testRunId", (Object)testRunId.toString());
            Response response2 = Response.ok((Object)response.toString()).build();
            return response2;
        }
    }

    @GET
    @Path(value="/{testSpecificationId:.+}")
    @Consumes(value={"application/json"})
    public Response getTestRun(@PathParam(value="testSpecificationId") String testSpecificationId, @Context HttpServletResponse response) throws Exception {
        response.addHeader("Cache-Control", "no-cache");
        response.addHeader("Connection", "keep-alive");
        ActiveTestSpecification testSpecification = this.getActiveTestSpecification(testSpecificationId);
        try {
            String runId = this.testSpecificationExecutor.importAllAvailableResults(testSpecification);
            return Response.ok((Object)("{ \"taskId\": \"" + runId + "\"}")).build();
        }
        catch (ExecutableAlreadyRunningException re) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)re.getMessage()).build();
        }
    }

    private ActiveTestSpecification getActiveTestSpecification(String testSpecificationId) {
        BaseTestSpecification baseTestSpecification = this.testSpecifications.getById(testSpecificationId);
        if (!baseTestSpecification.getType().instanceOf(Type.valueOf(ActiveTestSpecification.class))) {
            throw new IllegalArgumentException(String.format("Test Specification with id [%s] is not a subtype of xlt.ActiveTestSpecification", testSpecificationId));
        }
        return (ActiveTestSpecification)baseTestSpecification;
    }

    private String getRequiredValue(Map<String, Object> data, String key) {
        return this.getValue(data, key, Collections.emptySet(), true);
    }

    private String getRequiredValue(Map<String, Object> data, String key, Set<String> expected) {
        return this.getValue(data, key, expected, true);
    }

    private String getValue(Map<String, Object> data, String key, Set<String> expected, boolean required) {
        try {
            String value = (String)data.get(key);
            if (required && value == null) {
                LOG.debug("data ({}) did not contain required key {}", data, (Object)key);
                throw new IllegalArgumentException(String.format("expected a value for [%s] in request", key));
            }
            if (!expected.isEmpty() && !expected.contains(value)) {
                throw new IllegalArgumentException(String.format("expected one of [%s] for [%s] in request", expected.toString(), key));
            }
            data.remove(key);
            return value;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("unexpected value while looking up [%s] in request: %s", key, e.getMessage()));
        }
    }

    private String capitalize(String s) {
        if (s.isEmpty()) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    @VisibleForTesting
    Map<String, Object> buildEventData(BaseTestSpecification testSpecification, Map<String, Object> input) {
        String[] requiredProperties;
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("@testSpecification", testSpecification.getName());
        eventData.put("source", this.getRequiredValue(input, "source"));
        eventData.put("ciBuildResult", this.getRequiredValue(input, "buildResult", Sets.newHashSet((Object[])new String[]{"SUCCESS", "FAILURE"})));
        for (String property : requiredProperties = new String[]{"serverUrl", "buildNumber", "jobUrl", "jobName", "buildUrl", "executedOn"}) {
            String eventKey = "ci" + this.capitalize(property);
            eventData.put(eventKey, this.getRequiredValue(input, property));
        }
        if (input.containsKey("buildParameters")) {
            Map buildParameters = (Map)input.get("buildParameters");
            for (Map.Entry entry : buildParameters.entrySet()) {
                eventData.put("buildParameter" + this.capitalize((String)entry.getKey()), entry.getValue());
            }
            input.remove("buildParameters");
        }
        if (!input.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append("Extra properties encountered in import request: ");
            for (Map.Entry<String, Object> entry : input.entrySet()) {
                message.append("[");
                message.append(entry.getKey());
                message.append("=");
                message.append(entry.getValue().toString());
                message.append("]\n");
            }
            throw new IllegalArgumentException(message.toString());
        }
        return eventData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTestRunData(BaseTestSpecification testSpecification, String testRunId, Map<String, Object> metadata, InputStream data) throws IOException, ImportException {
        File localWorkspaceDirectory = null;
        try {
            localWorkspaceDirectory = this.extractZipInputStreamToTempLocalWorkspaceDirectory(data);
            this.importService.importTestResults(testSpecification, testRunId, LocalFile.valueOf((File)localWorkspaceDirectory), metadata);
        }
        finally {
            if (localWorkspaceDirectory != null) {
                LOG.debug("Deleting recursively -> {}", (Object)localWorkspaceDirectory.getAbsolutePath());
                FileSystemUtils.deleteRecursively((File)localWorkspaceDirectory);
            }
        }
    }

    private File extractZipInputStreamToTempLocalWorkspaceDirectory(InputStream inputStream) throws IOException {
        File localWorkspaceDirectory = Files.createTempDir();
        this.extractZipInputStream(localWorkspaceDirectory, inputStream);
        LOG.info("Extracted zip content into: " + localWorkspaceDirectory.getAbsolutePath());
        return localWorkspaceDirectory;
    }

    private void extractZipInputStream(File baseDir, InputStream is) throws IOException {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(is);
        while ((entry = zis.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            File file = new File(baseDir, entry.getName());
            LOG.debug("Copying {} into file {}", (Object)entry.getName(), (Object)file);
            Files.createParentDirs((File)file);
            Files.write((byte[])ByteStreams.toByteArray((InputStream)zis), (File)file);
        }
    }
}

